/*****************************************************************************
FILE: convert_espa_to_hdf5.h
  
PURPOSE: Contains prototypes to read the ESPA XML metadata file
and imagery, and convert from raw binary to HDF5 file format.

NOTES:
*****************************************************************************/
#ifndef CONVERT_ESPA_TO_HDF5_H
#define CONVERT_ESPA_TO_HDF5_H

#include <stdbool.h>

/* Prototypes */
int convert_espa_to_hdf5
(
    const char *espa_xml_file,   /* I: input ESPA XML metadata filename */
    const char *hdf5_file,       /* I: output HDF5 filename */
    bool del_src,          /* I: should the source files be removed after
                                 conversion? */
    bool all_bands         /* I: should all bands be converted? */
);

#endif
