/*****************************************************************************
FILE: setup_ias_l1g_metadata.h

PURPOSE: Contains defines and prototypes for setting up IAS L1G I/O file and
         band metadata.

*****************************************************************************/
#ifndef IAS_L1G_METADATA_H
#define IAS_L1G_METADATA_H

#include "espa_metadata.h"
#include "ias_l1g.h"

int setup_file_metadata
(
    const Espa_internal_meta_t *xml_metadata, /* I: Source XML metadata */
    IAS_L1G_FILE_METADATA *fmd                /* O: File Metadata */
);

int setup_band_metadata
(
    const Espa_internal_meta_t *xml_metadata, /* I: Source XML metadata */
    int band_index,                           /* I: Index into xml_metadata of
                                                 band to use */
    IAS_L1G_BAND_METADATA *bmd                /* O: Band Metadata */
);

IAS_DATA_TYPE convert_to_ias_data_type
(
    const int espa_data_type   /* I: input ESPA data type */
);
#endif
