#!/bin/csh -f

#***********************************************************************
# NAME:     test_convert_hdf5.csh
# PURPOSE:  tests conversion of ESPA raw binary to HDF5
# RETURNS:  0 if successful, 1 on an error condition
#***********************************************************************/

# Get the location of the binary being run
if ($#argv != 1) then
  echo "Usage: $0 bindir"
  exit 1
endif
set bindir = $1

# Ensure the test environment is set
if ( ! $?ESPA_UNIT_TEST_DATA_DIR ) then
    echo "ESPA_UNIT_TEST_DATA_DIR isn't set"
    exit 1
endif
set ut="$ESPA_UNIT_TEST_DATA_DIR/espa-product-formatter/convert_espa_to_hdf5"

set test_no = 1
foreach input_xml ("all_l7.xml" "sr_l8.xml" "temp_st_sr_bands_to_format.xml")

    foreach test ("" "--all")

        echo "Running test $test_no $test for ${input_xml}"

        # Run the converter on the entire product
        echo -n "$bindir/convert_espa_to_hdf5 --xml=$ut/$input_xml $test"
        echo "   --hdf5=test$test_no.h5"
        $bindir/convert_espa_to_hdf5 --xml=$ut/$input_xml $test \
            --hdf5=test$test_no.h5
        if ($status != 0) then
            echo "Error running convert_espa_to_hdf5"
            exit 1
        endif

        # We don't care about actual band contents, but metadata and which 
        # bands were converted.  Do a dump to get a listing.
        echo "Comparing test$test_no.h5 to expected output"
        h5ls -l -w 10 "test$test_no.h5" > test$test_no.listing
        h5ls -l -w 10 -d "test$test_no.h5/File Metadata" >> test$test_no.listing
        h5ls -l -w 10 -d "test$test_no.h5/Band Metadata" >> test$test_no.listing
        diff -I"Software Version" test$test_no.listing $ut/test$test_no.listing
        if ($status != 0) then
            echo -n "Error in test$test_no.listing (compare to "
            echo "$ut/test$test_no.listing)"
            exit 1
        endif

        # Clean up output files
        rm test$test_no.h5 test$test_no.listing test${test_no}_hdf5.xml

        echo "Completed test $test_no $test for ${input_xml}"
        echo ""

        @ test_no = $test_no + 1
    end
end

echo ""

exit 0
