/*****************************************************************************
FILE: convert_espa_to_cog.h
  
PURPOSE: Contains defines and prototypes to read the ESPA XML metadata file
and imagery, and convert from raw binary to Cloud-Optimized GeoTIFF (COG) file
format.

PROJECT:  Land Satellites Data System Science Research and Development (LSRD)
at the USGS EROS

LICENSE TYPE:  NASA Open Source Agreement Version 1.3

NOTES:
*****************************************************************************/

#ifndef CONVERT_ESPA_TO_COG_H
#define CONVERT_ESPA_TO_COG_H

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "error_handler.h"
#include "espa_metadata.h"
#include "parse_metadata.h"
#include "write_metadata.h"

/* Defines */

/* Prototypes */
int convert_espa_to_cog
(
    char *espa_xml_file,   /* I: input ESPA XML metadata filename */
    char *cog_file,        /* I: base output COG filename */
    bool del_src           /* I: should the source files be removed after
                                 conversion? */
);

#endif
