/*****************************************************************************
FILE: convert_l2lpgs_to_espa.h
  
PURPOSE: Contains defines and prototypes to read Level-2 information from the
LPGS MTL file, create the XML metadata file, and convert from GeoTIFF to raw
binary file format.

PROJECT:  Land Satellites Data System Science Research and Development (LSRD)
at the USGS EROS

LICENSE TYPE:  NASA Open Source Agreement Version 1.3

NOTES:
*****************************************************************************/

#ifndef CONVERT_L2LPGS_TO_ESPA_H
#define CONVERT_L2LPGS_TO_ESPA_H

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "geotiffio.h"
#include "xtiffio.h"
#include "error_handler.h"
#include "espa_metadata.h"
#include "espa_geoloc.h"
#include "raw_binary_io.h"
#include "write_metadata.h"
#include "envi_header.h"

/* Defines */
typedef enum l2lpgs_bands {
    SR_B1=0, SR_B2=1, SR_B3=2, SR_B4=3, SR_B5=4, SR_B6=5, SR_B7=6,
                         /* SR_B6 only exists for OLI */
    ST_B6=7, ST_B10=7,   /* we will have B6 for TM/ETM or B10 for OLI */
    ST_TRAD=8, ST_URAD=9, ST_DRAD=10, ST_ATRAN=11, ST_EMIS=12, ST_EMSD=13,
    ST_CDIST=14,
    SR_ATMOS_OPACITY=15, /* only exists for TM/ETM */
    SR_CLOUD_QA=16, SR_AEROSOL=16, /* cloud QA is TM/ETM, aerosol is OLI */
    ST_QA, QA_PIXEL, QA_RADSAT, MAX_L2LPGS_BANDS} L2lpgs_bands_t;

/* Prototypes */
int convert_l2lpgs_to_espa
(
    char *lpgs_mtl_file,   /* I: input LPGS MTL metadata filename */
    char *espa_xml_file,   /* I: output ESPA XML metadata filename */
    bool del_src           /* I: should the source .tif files be removed after
                                 conversion? */
);

#endif
