/*****************************************************************************
FILE: convert_lpgs_to_espa.h
  
PURPOSE: Contains defines and prototypes to read Level-1 information from the
LPGS MTL file, create the XML metadata file, and convert from GeoTIFF to raw
binary file format.

PROJECT:  Land Satellites Data System Science Research and Development (LSRD)
at the USGS EROS

LICENSE TYPE:  NASA Open Source Agreement Version 1.3

NOTES:
*****************************************************************************/

#ifndef CONVERT_LPGS_TO_ESPA_H
#define CONVERT_LPGS_TO_ESPA_H

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "geotiffio.h"
#include "xtiffio.h"
#include "error_handler.h"
#include "espa_metadata.h"
#include "espa_geoloc.h"
#include "raw_binary_io.h"
#include "write_metadata.h"
#include "envi_header.h"

/* Defines */
/* Maximum number of Level-1 LPGS bands in a file; OLI/TIRS products have the
   most bands (11 image bands plus the quality band); TM has 7 bands; ETM+ has
   9 bands; also need to support the 4 angle bands and the RADSAT band. */
#define MAX_LPGS_BANDS 17

/* Prototypes */
int convert_lpgs_to_espa
(
    char *lpgs_mtl_file,   /* I: input LPGS MTL metadata filename */
    char *espa_xml_file,   /* I: output ESPA XML metadata filename */
    bool del_src           /* I: should the source .tif files be removed after
                                 conversion? */
);

#endif
