      subroutine   bdm

c - to vary the number of quadratures
      include "paramdef.inc"
      integer nquad
      common /num_quad/ nquad
      real ph,qh,uh
      common /sixs_aerbas/ ph(20,nqmax_p),qh(20,nqmax_p),uh(20,nqmax_p)
      real phr(20,nqdef_p),qhr(20,nqdef_p),uhr(20,nqdef_p)
c - to vary the number of quadratures
      real ex,sc,asy,vi
      common /sixs_coef/ ex(4,20),sc(4,20),asy(4,20),vi(4)
      real ex_m(20),sc_m(20),asy_m(20)
      integer i,j

c Background desert model
c Parameters and refractive indices - G.A. d'Almeida, 'Atmospheric
c aerosols. Global climatology and radiative characteristics', 1991,
c pp.48,80,102.
c Extinction coefficients are calculated in km-1

c*************** MIE (asy) ******************
      data (asy_m(j),j=1,20)/
     a 0.701,0.690,0.687,0.681,0.677,0.675,0.671,0.665,0.660,0.655,
     a 0.651,0.648,0.639,0.626,0.583,0.587,0.583,0.595,0.605,0.547/
c*************** MIE (ext&sca) ******************
        data (ex_m(j),sc_m(j),j=1,20) /
     a 0.9978367E-01,0.8870113E-01,0.9390490E-01,0.8606911E-01,
     a 0.9241579E-01,0.8536333E-01,0.8848752E-01,0.8329929E-01,
     a 0.8496436E-01,0.8053116E-01,0.8261336E-01,0.7846993E-01,
     a 0.7913338E-01,0.7561909E-01,0.7475012E-01,0.7217911E-01,
     a 0.6989562E-01,0.6785794E-01,0.6496391E-01,0.6316575E-01,
     a 0.6097984E-01,0.5937214E-01,0.5852314E-01,0.5706264E-01,
     a 0.5225345E-01,0.5114494E-01,0.4403058E-01,0.4369425E-01,
     a 0.2414531E-01,0.2392341E-01,0.1078730E-01,0.1061324E-01,
     a 0.8476357E-02,0.8300470E-02,0.3624489E-02,0.3460222E-02,
     a 0.1813242E-02,0.1624963E-02,0.1101573E-02,0.6737047E-03 /
c************** MIE (phase fun ph) ***************
        DATA ((PHR(i,j),j=1,83),i= 1, 1)/
     *0.3494E+00,0.3432E+00,0.3196E+00,0.2868E+00,0.2541E+00,
     *0.2281E+00,0.2113E+00,0.2032E+00,0.2008E+00,0.2006E+00,
     *0.1999E+00,0.1976E+00,0.1935E+00,0.1877E+00,0.1811E+00,
     *0.1740E+00,0.1670E+00,0.1603E+00,0.1543E+00,0.1490E+00,
     *0.1445E+00,0.1407E+00,0.1378E+00,0.1357E+00,0.1343E+00,
     *0.1336E+00,0.1336E+00,0.1344E+00,0.1358E+00,0.1380E+00,
     *0.1410E+00,0.1446E+00,0.1491E+00,0.1543E+00,0.1605E+00,
     *0.1676E+00,0.1757E+00,0.1849E+00,0.1953E+00,0.2070E+00,
     *0.2202E+00,0.2274E+00,0.2351E+00,0.2518E+00,0.2706E+00,
     *0.2918E+00,0.3155E+00,0.3422E+00,0.3722E+00,0.4060E+00,
     *0.4442E+00,0.4873E+00,0.5361E+00,0.5913E+00,0.6539E+00,
     *0.7251E+00,0.8061E+00,0.8983E+00,0.1004E+01,0.1124E+01,
     *0.1262E+01,0.1420E+01,0.1602E+01,0.1812E+01,0.2054E+01,
     *0.2333E+01,0.2655E+01,0.3030E+01,0.3465E+01,0.3971E+01,
     *0.4562E+01,0.5253E+01,0.6062E+01,0.7012E+01,0.8127E+01,
     *0.9440E+01,0.1098E+02,0.1278E+02,0.1487E+02,0.1727E+02,
     *0.2006E+02,0.2372E+02,0.2698E+02 /
        DATA ((PHR(i,j),j=1,83),i= 2, 2)/
     *0.3524E+00,0.3465E+00,0.3245E+00,0.2939E+00,0.2629E+00,
     *0.2374E+00,0.2201E+00,0.2108E+00,0.2069E+00,0.2052E+00,
     *0.2036E+00,0.2008E+00,0.1966E+00,0.1910E+00,0.1847E+00,
     *0.1780E+00,0.1714E+00,0.1651E+00,0.1594E+00,0.1543E+00,
     *0.1499E+00,0.1463E+00,0.1435E+00,0.1414E+00,0.1400E+00,
     *0.1393E+00,0.1394E+00,0.1402E+00,0.1417E+00,0.1440E+00,
     *0.1470E+00,0.1507E+00,0.1554E+00,0.1608E+00,0.1672E+00,
     *0.1745E+00,0.1829E+00,0.1925E+00,0.2034E+00,0.2156E+00,
     *0.2294E+00,0.2370E+00,0.2450E+00,0.2625E+00,0.2822E+00,
     *0.3043E+00,0.3291E+00,0.3571E+00,0.3886E+00,0.4241E+00,
     *0.4642E+00,0.5095E+00,0.5606E+00,0.6185E+00,0.6842E+00,
     *0.7589E+00,0.8437E+00,0.9403E+00,0.1050E+01,0.1176E+01,
     *0.1320E+01,0.1484E+01,0.1672E+01,0.1888E+01,0.2136E+01,
     *0.2420E+01,0.2748E+01,0.3124E+01,0.3558E+01,0.4057E+01,
     *0.4632E+01,0.5295E+01,0.6059E+01,0.6938E+01,0.7948E+01,
     *0.9106E+01,0.1043E+02,0.1193E+02,0.1361E+02,0.1549E+02,
     *0.1763E+02,0.2043E+02,0.2269E+02 /
        DATA ((PHR(i,j),j=1,83),i= 3, 3)/
     *0.3543E+00,0.3485E+00,0.3269E+00,0.2968E+00,0.2661E+00,
     *0.2406E+00,0.2232E+00,0.2135E+00,0.2092E+00,0.2072E+00,
     *0.2053E+00,0.2023E+00,0.1979E+00,0.1923E+00,0.1860E+00,
     *0.1794E+00,0.1728E+00,0.1665E+00,0.1608E+00,0.1558E+00,
     *0.1514E+00,0.1478E+00,0.1450E+00,0.1428E+00,0.1414E+00,
     *0.1408E+00,0.1409E+00,0.1417E+00,0.1432E+00,0.1455E+00,
     *0.1485E+00,0.1523E+00,0.1569E+00,0.1624E+00,0.1688E+00,
     *0.1762E+00,0.1847E+00,0.1944E+00,0.2053E+00,0.2177E+00,
     *0.2317E+00,0.2393E+00,0.2474E+00,0.2651E+00,0.2850E+00,
     *0.3073E+00,0.3324E+00,0.3607E+00,0.3925E+00,0.4285E+00,
     *0.4690E+00,0.5148E+00,0.5664E+00,0.6250E+00,0.6913E+00,
     *0.7667E+00,0.8523E+00,0.9499E+00,0.1061E+01,0.1188E+01,
     *0.1333E+01,0.1498E+01,0.1687E+01,0.1904E+01,0.2153E+01,
     *0.2438E+01,0.2766E+01,0.3142E+01,0.3575E+01,0.4071E+01,
     *0.4642E+01,0.5297E+01,0.6050E+01,0.6913E+01,0.7900E+01,
     *0.9025E+01,0.1030E+02,0.1174E+02,0.1335E+02,0.1513E+02,
     *0.1715E+02,0.1978E+02,0.2187E+02 /
        DATA ((PHR(i,j),j=1,83),i= 4, 4)/
     *0.3623E+00,0.3565E+00,0.3352E+00,0.3054E+00,0.2749E+00,
     *0.2493E+00,0.2313E+00,0.2208E+00,0.2155E+00,0.2125E+00,
     *0.2098E+00,0.2063E+00,0.2016E+00,0.1959E+00,0.1895E+00,
     *0.1829E+00,0.1763E+00,0.1701E+00,0.1645E+00,0.1595E+00,
     *0.1552E+00,0.1516E+00,0.1488E+00,0.1466E+00,0.1452E+00,
     *0.1445E+00,0.1446E+00,0.1455E+00,0.1470E+00,0.1494E+00,
     *0.1524E+00,0.1563E+00,0.1611E+00,0.1667E+00,0.1732E+00,
     *0.1808E+00,0.1895E+00,0.1994E+00,0.2106E+00,0.2233E+00,
     *0.2376E+00,0.2454E+00,0.2537E+00,0.2719E+00,0.2923E+00,
     *0.3152E+00,0.3410E+00,0.3700E+00,0.4027E+00,0.4396E+00,
     *0.4812E+00,0.5281E+00,0.5811E+00,0.6410E+00,0.7090E+00,
     *0.7862E+00,0.8738E+00,0.9734E+00,0.1087E+01,0.1216E+01,
     *0.1363E+01,0.1531E+01,0.1723E+01,0.1942E+01,0.2193E+01,
     *0.2479E+01,0.2807E+01,0.3182E+01,0.3610E+01,0.4099E+01,
     *0.4658E+01,0.5295E+01,0.6019E+01,0.6842E+01,0.7773E+01,
     *0.8821E+01,0.9994E+01,0.1130E+02,0.1273E+02,0.1430E+02,
     *0.1607E+02,0.1836E+02,0.2008E+02 /
        DATA ((PHR(i,j),j=1,83),i= 5, 5)/
     *0.3549E+00,0.3494E+00,0.3296E+00,0.3019E+00,0.2732E+00,
     *0.2488E+00,0.2314E+00,0.2207E+00,0.2151E+00,0.2118E+00,
     *0.2089E+00,0.2053E+00,0.2006E+00,0.1952E+00,0.1892E+00,
     *0.1829E+00,0.1767E+00,0.1709E+00,0.1655E+00,0.1607E+00,
     *0.1566E+00,0.1531E+00,0.1504E+00,0.1484E+00,0.1472E+00,
     *0.1467E+00,0.1469E+00,0.1478E+00,0.1495E+00,0.1519E+00,
     *0.1550E+00,0.1590E+00,0.1638E+00,0.1695E+00,0.1762E+00,
     *0.1839E+00,0.1928E+00,0.2028E+00,0.2143E+00,0.2273E+00,
     *0.2419E+00,0.2499E+00,0.2583E+00,0.2768E+00,0.2975E+00,
     *0.3209E+00,0.3473E+00,0.3769E+00,0.4103E+00,0.4479E+00,
     *0.4902E+00,0.5381E+00,0.5922E+00,0.6533E+00,0.7226E+00,
     *0.8010E+00,0.8901E+00,0.9913E+00,0.1106E+01,0.1237E+01,
     *0.1387E+01,0.1556E+01,0.1750E+01,0.1971E+01,0.2223E+01,
     *0.2510E+01,0.2838E+01,0.3211E+01,0.3636E+01,0.4120E+01,
     *0.4669E+01,0.5292E+01,0.5996E+01,0.6790E+01,0.7681E+01,
     *0.8675E+01,0.9777E+01,0.1099E+02,0.1230E+02,0.1373E+02,
     *0.1535E+02,0.1742E+02,0.1891E+02 /
        DATA ((PHR(i,j),j=1,83),i= 6, 6)/
     *0.3501E+00,0.3448E+00,0.3255E+00,0.2985E+00,0.2707E+00,
     *0.2469E+00,0.2298E+00,0.2193E+00,0.2136E+00,0.2101E+00,
     *0.2071E+00,0.2036E+00,0.1992E+00,0.1941E+00,0.1883E+00,
     *0.1823E+00,0.1764E+00,0.1708E+00,0.1657E+00,0.1611E+00,
     *0.1572E+00,0.1539E+00,0.1513E+00,0.1495E+00,0.1483E+00,
     *0.1478E+00,0.1481E+00,0.1490E+00,0.1507E+00,0.1532E+00,
     *0.1565E+00,0.1606E+00,0.1655E+00,0.1713E+00,0.1781E+00,
     *0.1859E+00,0.1949E+00,0.2052E+00,0.2168E+00,0.2299E+00,
     *0.2446E+00,0.2527E+00,0.2612E+00,0.2800E+00,0.3012E+00,
     *0.3249E+00,0.3515E+00,0.3815E+00,0.4152E+00,0.4533E+00,
     *0.4962E+00,0.5446E+00,0.5993E+00,0.6612E+00,0.7312E+00,
     *0.8106E+00,0.9005E+00,0.1003E+01,0.1119E+01,0.1251E+01,
     *0.1401E+01,0.1572E+01,0.1766E+01,0.1988E+01,0.2241E+01,
     *0.2528E+01,0.2855E+01,0.3227E+01,0.3651E+01,0.4130E+01,
     *0.4674E+01,0.5288E+01,0.5980E+01,0.6756E+01,0.7623E+01,
     *0.8585E+01,0.9645E+01,0.1080E+02,0.1205E+02,0.1341E+02,
     *0.1495E+02,0.1689E+02,0.1825E+02 /
        DATA ((PHR(i,j),j=1,83),i= 7, 7)/
     *0.3444E+00,0.3394E+00,0.3213E+00,0.2961E+00,0.2698E+00,
     *0.2470E+00,0.2303E+00,0.2198E+00,0.2138E+00,0.2100E+00,
     *0.2067E+00,0.2031E+00,0.1988E+00,0.1938E+00,0.1883E+00,
     *0.1826E+00,0.1770E+00,0.1717E+00,0.1668E+00,0.1625E+00,
     *0.1587E+00,0.1557E+00,0.1532E+00,0.1515E+00,0.1504E+00,
     *0.1500E+00,0.1503E+00,0.1513E+00,0.1531E+00,0.1557E+00,
     *0.1591E+00,0.1632E+00,0.1683E+00,0.1742E+00,0.1811E+00,
     *0.1891E+00,0.1983E+00,0.2087E+00,0.2205E+00,0.2339E+00,
     *0.2489E+00,0.2572E+00,0.2659E+00,0.2851E+00,0.3066E+00,
     *0.3307E+00,0.3579E+00,0.3884E+00,0.4228E+00,0.4616E+00,
     *0.5053E+00,0.5546E+00,0.6102E+00,0.6730E+00,0.7442E+00,
     *0.8247E+00,0.9160E+00,0.1020E+01,0.1137E+01,0.1270E+01,
     *0.1422E+01,0.1594E+01,0.1790E+01,0.2013E+01,0.2266E+01,
     *0.2553E+01,0.2879E+01,0.3249E+01,0.3668E+01,0.4141E+01,
     *0.4675E+01,0.5276E+01,0.5948E+01,0.6698E+01,0.7530E+01,
     *0.8446E+01,0.9447E+01,0.1053E+02,0.1169E+02,0.1295E+02,
     *0.1436E+02,0.1613E+02,0.1732E+02 /
        DATA ((PHR(i,j),j=1,83),i= 8, 8)/
     *0.3445E+00,0.3396E+00,0.3223E+00,0.2982E+00,0.2729E+00,
     *0.2510E+00,0.2345E+00,0.2236E+00,0.2170E+00,0.2127E+00,
     *0.2091E+00,0.2051E+00,0.2005E+00,0.1955E+00,0.1901E+00,
     *0.1846E+00,0.1791E+00,0.1740E+00,0.1692E+00,0.1650E+00,
     *0.1613E+00,0.1584E+00,0.1560E+00,0.1544E+00,0.1535E+00,
     *0.1533E+00,0.1537E+00,0.1549E+00,0.1567E+00,0.1594E+00,
     *0.1628E+00,0.1671E+00,0.1722E+00,0.1783E+00,0.1854E+00,
     *0.1937E+00,0.2030E+00,0.2137E+00,0.2258E+00,0.2394E+00,
     *0.2549E+00,0.2633E+00,0.2723E+00,0.2918E+00,0.3139E+00,
     *0.3386E+00,0.3665E+00,0.3978E+00,0.4330E+00,0.4725E+00,
     *0.5171E+00,0.5675E+00,0.6243E+00,0.6885E+00,0.7609E+00,
     *0.8428E+00,0.9356E+00,0.1041E+01,0.1159E+01,0.1294E+01,
     *0.1447E+01,0.1621E+01,0.1818E+01,0.2041E+01,0.2294E+01,
     *0.2580E+01,0.2904E+01,0.3270E+01,0.3682E+01,0.4147E+01,
     *0.4667E+01,0.5249E+01,0.5897E+01,0.6614E+01,0.7403E+01,
     *0.8264E+01,0.9196E+01,0.1020E+02,0.1126E+02,0.1241E+02,
     *0.1370E+02,0.1529E+02,0.1632E+02 /
        DATA ((PHR(i,j),j=1,83),i= 9, 9)/
     *0.3352E+00,0.3308E+00,0.3154E+00,0.2937E+00,0.2706E+00,
     *0.2501E+00,0.2344E+00,0.2238E+00,0.2170E+00,0.2124E+00,
     *0.2085E+00,0.2045E+00,0.2001E+00,0.1952E+00,0.1902E+00,
     *0.1851E+00,0.1800E+00,0.1752E+00,0.1708E+00,0.1669E+00,
     *0.1636E+00,0.1608E+00,0.1587E+00,0.1572E+00,0.1564E+00,
     *0.1563E+00,0.1569E+00,0.1582E+00,0.1602E+00,0.1630E+00,
     *0.1665E+00,0.1709E+00,0.1762E+00,0.1825E+00,0.1898E+00,
     *0.1982E+00,0.2078E+00,0.2187E+00,0.2312E+00,0.2453E+00,
     *0.2612E+00,0.2699E+00,0.2791E+00,0.2991E+00,0.3216E+00,
     *0.3469E+00,0.3755E+00,0.4076E+00,0.4437E+00,0.4843E+00,
     *0.5299E+00,0.5814E+00,0.6394E+00,0.7048E+00,0.7786E+00,
     *0.8620E+00,0.9562E+00,0.1063E+01,0.1183E+01,0.1320E+01,
     *0.1474E+01,0.1649E+01,0.1846E+01,0.2070E+01,0.2322E+01,
     *0.2607E+01,0.2928E+01,0.3289E+01,0.3695E+01,0.4149E+01,
     *0.4656E+01,0.5219E+01,0.5841E+01,0.6526E+01,0.7273E+01,
     *0.8082E+01,0.8949E+01,0.9871E+01,0.1085E+02,0.1189E+02,
     *0.1306E+02,0.1448E+02,0.1535E+02 /
        DATA ((PHR(i,j),j=1,83),i=10,10)/
     *0.3251E+00,0.3211E+00,0.3071E+00,0.2874E+00,0.2664E+00,
     *0.2475E+00,0.2326E+00,0.2224E+00,0.2157E+00,0.2109E+00,
     *0.2069E+00,0.2030E+00,0.1989E+00,0.1944E+00,0.1897E+00,
     *0.1850E+00,0.1804E+00,0.1760E+00,0.1720E+00,0.1685E+00,
     *0.1655E+00,0.1630E+00,0.1611E+00,0.1599E+00,0.1592E+00,
     *0.1592E+00,0.1600E+00,0.1614E+00,0.1636E+00,0.1665E+00,
     *0.1703E+00,0.1749E+00,0.1804E+00,0.1868E+00,0.1944E+00,
     *0.2030E+00,0.2129E+00,0.2242E+00,0.2370E+00,0.2515E+00,
     *0.2678E+00,0.2767E+00,0.2861E+00,0.3068E+00,0.3299E+00,
     *0.3559E+00,0.3852E+00,0.4180E+00,0.4550E+00,0.4965E+00,
     *0.5433E+00,0.5959E+00,0.6550E+00,0.7216E+00,0.7967E+00,
     *0.8815E+00,0.9772E+00,0.1085E+01,0.1207E+01,0.1345E+01,
     *0.1500E+01,0.1675E+01,0.1873E+01,0.2096E+01,0.2348E+01,
     *0.2631E+01,0.2948E+01,0.3304E+01,0.3702E+01,0.4146E+01,
     *0.4638E+01,0.5182E+01,0.5780E+01,0.6433E+01,0.7141E+01,
     *0.7901E+01,0.8711E+01,0.9564E+01,0.1046E+02,0.1142E+02,
     *0.1249E+02,0.1378E+02,0.1452E+02 /
        DATA ((PHR(i,j),j=1,83),i=11,11)/
     *0.3184E+00,0.3146E+00,0.3017E+00,0.2836E+00,0.2641E+00,
     *0.2464E+00,0.2325E+00,0.2226E+00,0.2159E+00,0.2111E+00,
     *0.2070E+00,0.2030E+00,0.1989E+00,0.1945E+00,0.1901E+00,
     *0.1856E+00,0.1813E+00,0.1772E+00,0.1735E+00,0.1701E+00,
     *0.1673E+00,0.1651E+00,0.1633E+00,0.1622E+00,0.1618E+00,
     *0.1620E+00,0.1629E+00,0.1645E+00,0.1668E+00,0.1698E+00,
     *0.1737E+00,0.1784E+00,0.1840E+00,0.1907E+00,0.1984E+00,
     *0.2073E+00,0.2174E+00,0.2289E+00,0.2420E+00,0.2568E+00,
     *0.2735E+00,0.2826E+00,0.2923E+00,0.3133E+00,0.3369E+00,
     *0.3635E+00,0.3934E+00,0.4269E+00,0.4646E+00,0.5069E+00,
     *0.5544E+00,0.6078E+00,0.6680E+00,0.7357E+00,0.8118E+00,
     *0.8976E+00,0.9943E+00,0.1103E+01,0.1226E+01,0.1365E+01,
     *0.1521E+01,0.1696E+01,0.1894E+01,0.2117E+01,0.2367E+01,
     *0.2647E+01,0.2962E+01,0.3313E+01,0.3704E+01,0.4138E+01,
     *0.4618E+01,0.5146E+01,0.5724E+01,0.6352E+01,0.7029E+01,
     *0.7752E+01,0.8518E+01,0.9322E+01,0.1017E+02,0.1106E+02,
     *0.1207E+02,0.1326E+02,0.1392E+02 /
        DATA ((PHR(i,j),j=1,83),i=12,12)/
     *0.3186E+00,0.3148E+00,0.3016E+00,0.2834E+00,0.2641E+00,
     *0.2469E+00,0.2333E+00,0.2235E+00,0.2168E+00,0.2118E+00,
     *0.2076E+00,0.2036E+00,0.1995E+00,0.1952E+00,0.1909E+00,
     *0.1865E+00,0.1823E+00,0.1783E+00,0.1747E+00,0.1715E+00,
     *0.1688E+00,0.1666E+00,0.1650E+00,0.1640E+00,0.1637E+00,
     *0.1639E+00,0.1649E+00,0.1665E+00,0.1688E+00,0.1720E+00,
     *0.1760E+00,0.1808E+00,0.1866E+00,0.1934E+00,0.2012E+00,
     *0.2102E+00,0.2205E+00,0.2323E+00,0.2455E+00,0.2605E+00,
     *0.2773E+00,0.2865E+00,0.2963E+00,0.3177E+00,0.3417E+00,
     *0.3687E+00,0.3989E+00,0.4328E+00,0.4709E+00,0.5136E+00,
     *0.5616E+00,0.6156E+00,0.6763E+00,0.7446E+00,0.8214E+00,
     *0.9078E+00,0.1005E+01,0.1115E+01,0.1238E+01,0.1376E+01,
     *0.1533E+01,0.1708E+01,0.1906E+01,0.2128E+01,0.2377E+01,
     *0.2656E+01,0.2968E+01,0.3315E+01,0.3702E+01,0.4130E+01,
     *0.4602E+01,0.5120E+01,0.5686E+01,0.6298E+01,0.6956E+01,
     *0.7656E+01,0.8395E+01,0.9171E+01,0.9985E+01,0.1085E+02,
     *0.1183E+02,0.1296E+02,0.1358E+02 /
        DATA ((PHR(i,j),j=1,83),i=13,13)/
     *0.3108E+00,0.3076E+00,0.2963E+00,0.2807E+00,0.2639E+00,
     *0.2484E+00,0.2357E+00,0.2264E+00,0.2198E+00,0.2147E+00,
     *0.2103E+00,0.2061E+00,0.2020E+00,0.1978E+00,0.1936E+00,
     *0.1895E+00,0.1856E+00,0.1820E+00,0.1786E+00,0.1757E+00,
     *0.1733E+00,0.1714E+00,0.1700E+00,0.1692E+00,0.1690E+00,
     *0.1694E+00,0.1705E+00,0.1724E+00,0.1749E+00,0.1783E+00,
     *0.1824E+00,0.1874E+00,0.1934E+00,0.2005E+00,0.2086E+00,
     *0.2180E+00,0.2286E+00,0.2407E+00,0.2545E+00,0.2701E+00,
     *0.2876E+00,0.2972E+00,0.3073E+00,0.3293E+00,0.3541E+00,
     *0.3819E+00,0.4131E+00,0.4481E+00,0.4874E+00,0.5314E+00,
     *0.5807E+00,0.6361E+00,0.6982E+00,0.7679E+00,0.8462E+00,
     *0.9340E+00,0.1033E+01,0.1143E+01,0.1268E+01,0.1407E+01,
     *0.1564E+01,0.1740E+01,0.1936E+01,0.2156E+01,0.2402E+01,
     *0.2676E+01,0.2981E+01,0.3319E+01,0.3693E+01,0.4104E+01,
     *0.4556E+01,0.5048E+01,0.5581E+01,0.6154E+01,0.6766E+01,
     *0.7412E+01,0.8090E+01,0.8797E+01,0.9536E+01,0.1032E+02,
     *0.1120E+02,0.1220E+02,0.1271E+02 /
        DATA ((PHR(i,j),j=1,83),i=14,14)/
     *0.3172E+00,0.3140E+00,0.3035E+00,0.2893E+00,0.2739E+00,
     *0.2593E+00,0.2471E+00,0.2379E+00,0.2310E+00,0.2253E+00,
     *0.2203E+00,0.2156E+00,0.2110E+00,0.2065E+00,0.2022E+00,
     *0.1981E+00,0.1942E+00,0.1907E+00,0.1875E+00,0.1847E+00,
     *0.1824E+00,0.1806E+00,0.1793E+00,0.1786E+00,0.1785E+00,
     *0.1791E+00,0.1804E+00,0.1824E+00,0.1851E+00,0.1886E+00,
     *0.1930E+00,0.1982E+00,0.2045E+00,0.2119E+00,0.2205E+00,
     *0.2303E+00,0.2414E+00,0.2542E+00,0.2686E+00,0.2849E+00,
     *0.3032E+00,0.3133E+00,0.3239E+00,0.3469E+00,0.3728E+00,
     *0.4017E+00,0.4343E+00,0.4707E+00,0.5115E+00,0.5570E+00,
     *0.6080E+00,0.6651E+00,0.7289E+00,0.8003E+00,0.8802E+00,
     *0.9697E+00,0.1070E+01,0.1182E+01,0.1307E+01,0.1447E+01,
     *0.1603E+01,0.1777E+01,0.1970E+01,0.2186E+01,0.2426E+01,
     *0.2691E+01,0.2984E+01,0.3308E+01,0.3662E+01,0.4050E+01,
     *0.4472E+01,0.4927E+01,0.5417E+01,0.5939E+01,0.6490E+01,
     *0.7069E+01,0.7672E+01,0.8297E+01,0.8950E+01,0.9647E+01,
     *0.1042E+02,0.1126E+02,0.1165E+02 /
        DATA ((PHR(i,j),j=1,83),i=15,15)/
     *0.3355E+00,0.3327E+00,0.3233E+00,0.3114E+00,0.2995E+00,
     *0.2889E+00,0.2799E+00,0.2725E+00,0.2664E+00,0.2611E+00,
     *0.2560E+00,0.2509E+00,0.2459E+00,0.2412E+00,0.2367E+00,
     *0.2326E+00,0.2287E+00,0.2253E+00,0.2223E+00,0.2197E+00,
     *0.2176E+00,0.2160E+00,0.2150E+00,0.2145E+00,0.2147E+00,
     *0.2156E+00,0.2171E+00,0.2193E+00,0.2224E+00,0.2264E+00,
     *0.2313E+00,0.2373E+00,0.2444E+00,0.2526E+00,0.2622E+00,
     *0.2733E+00,0.2859E+00,0.3002E+00,0.3164E+00,0.3346E+00,
     *0.3552E+00,0.3664E+00,0.3782E+00,0.4040E+00,0.4329E+00,
     *0.4650E+00,0.5009E+00,0.5408E+00,0.5851E+00,0.6343E+00,
     *0.6890E+00,0.7496E+00,0.8170E+00,0.8915E+00,0.9741E+00,
     *0.1065E+01,0.1166E+01,0.1277E+01,0.1400E+01,0.1536E+01,
     *0.1685E+01,0.1848E+01,0.2028E+01,0.2224E+01,0.2439E+01,
     *0.2673E+01,0.2927E+01,0.3201E+01,0.3497E+01,0.3815E+01,
     *0.4154E+01,0.4515E+01,0.4896E+01,0.5296E+01,0.5714E+01,
     *0.6150E+01,0.6604E+01,0.7079E+01,0.7583E+01,0.8128E+01,
     *0.8710E+01,0.9260E+01,0.9472E+01 /
        DATA ((PHR(i,j),j=1,83),i=16,16)/
     *0.2986E+00,0.2970E+00,0.2925E+00,0.2886E+00,0.2868E+00,
     *0.2865E+00,0.2862E+00,0.2849E+00,0.2824E+00,0.2789E+00,
     *0.2746E+00,0.2696E+00,0.2644E+00,0.2592E+00,0.2541E+00,
     *0.2492E+00,0.2446E+00,0.2403E+00,0.2364E+00,0.2329E+00,
     *0.2299E+00,0.2274E+00,0.2253E+00,0.2238E+00,0.2229E+00,
     *0.2226E+00,0.2229E+00,0.2239E+00,0.2258E+00,0.2284E+00,
     *0.2320E+00,0.2365E+00,0.2421E+00,0.2488E+00,0.2568E+00,
     *0.2662E+00,0.2772E+00,0.2898E+00,0.3042E+00,0.3207E+00,
     *0.3395E+00,0.3497E+00,0.3606E+00,0.3844E+00,0.4113E+00,
     *0.4415E+00,0.4752E+00,0.5129E+00,0.5551E+00,0.6021E+00,
     *0.6544E+00,0.7126E+00,0.7774E+00,0.8494E+00,0.9292E+00,
     *0.1018E+01,0.1116E+01,0.1225E+01,0.1345E+01,0.1478E+01,
     *0.1625E+01,0.1788E+01,0.1967E+01,0.2164E+01,0.2380E+01,
     *0.2618E+01,0.2879E+01,0.3164E+01,0.3475E+01,0.3814E+01,
     *0.4181E+01,0.4578E+01,0.5006E+01,0.5466E+01,0.5960E+01,
     *0.6490E+01,0.7058E+01,0.7669E+01,0.8329E+01,0.9041E+01,
     *0.9780E+01,0.1043E+02,0.1066E+02 /
        DATA ((PHR(i,j),j=1,83),i=17,17)/
     *0.3040E+00,0.3027E+00,0.2989E+00,0.2955E+00,0.2941E+00,
     *0.2941E+00,0.2940E+00,0.2929E+00,0.2906E+00,0.2870E+00,
     *0.2828E+00,0.2783E+00,0.2735E+00,0.2686E+00,0.2637E+00,
     *0.2588E+00,0.2543E+00,0.2501E+00,0.2461E+00,0.2426E+00,
     *0.2394E+00,0.2367E+00,0.2344E+00,0.2326E+00,0.2315E+00,
     *0.2308E+00,0.2309E+00,0.2316E+00,0.2331E+00,0.2354E+00,
     *0.2386E+00,0.2427E+00,0.2479E+00,0.2543E+00,0.2619E+00,
     *0.2709E+00,0.2814E+00,0.2936E+00,0.3077E+00,0.3237E+00,
     *0.3419E+00,0.3519E+00,0.3626E+00,0.3860E+00,0.4123E+00,
     *0.4418E+00,0.4750E+00,0.5120E+00,0.5534E+00,0.5996E+00,
     *0.6511E+00,0.7084E+00,0.7719E+00,0.8426E+00,0.9211E+00,
     *0.1008E+01,0.1105E+01,0.1211E+01,0.1329E+01,0.1460E+01,
     *0.1604E+01,0.1764E+01,0.1940E+01,0.2134E+01,0.2348E+01,
     *0.2583E+01,0.2842E+01,0.3125E+01,0.3436E+01,0.3776E+01,
     *0.4146E+01,0.4550E+01,0.4989E+01,0.5464E+01,0.5978E+01,
     *0.6535E+01,0.7138E+01,0.7793E+01,0.8502E+01,0.9258E+01,
     *0.1003E+02,0.1069E+02,0.1091E+02 /
        DATA ((PHR(i,j),j=1,83),i=18,18)/
     *0.3020E+00,0.3011E+00,0.2986E+00,0.2971E+00,0.2968E+00,
     *0.2964E+00,0.2950E+00,0.2928E+00,0.2901E+00,0.2870E+00,
     *0.2837E+00,0.2804E+00,0.2771E+00,0.2737E+00,0.2704E+00,
     *0.2671E+00,0.2638E+00,0.2605E+00,0.2574E+00,0.2543E+00,
     *0.2515E+00,0.2488E+00,0.2464E+00,0.2444E+00,0.2427E+00,
     *0.2414E+00,0.2407E+00,0.2405E+00,0.2409E+00,0.2420E+00,
     *0.2439E+00,0.2466E+00,0.2503E+00,0.2549E+00,0.2607E+00,
     *0.2678E+00,0.2762E+00,0.2861E+00,0.2977E+00,0.3111E+00,
     *0.3266E+00,0.3351E+00,0.3442E+00,0.3643E+00,0.3871E+00,
     *0.4128E+00,0.4418E+00,0.4743E+00,0.5109E+00,0.5517E+00,
     *0.5974E+00,0.6483E+00,0.7051E+00,0.7684E+00,0.8389E+00,
     *0.9173E+00,0.1004E+01,0.1102E+01,0.1209E+01,0.1330E+01,
     *0.1464E+01,0.1613E+01,0.1780E+01,0.1966E+01,0.2174E+01,
     *0.2408E+01,0.2671E+01,0.2967E+01,0.3301E+01,0.3679E+01,
     *0.4109E+01,0.4597E+01,0.5153E+01,0.5786E+01,0.6507E+01,
     *0.7327E+01,0.8254E+01,0.9293E+01,0.1044E+02,0.1166E+02,
     *0.1287E+02,0.1383E+02,0.1415E+02 /
        DATA ((PHR(i,j),j=1,83),i=19,19)/
     *0.3020E+00,0.3015E+00,0.3003E+00,0.2996E+00,0.2990E+00,
     *0.2979E+00,0.2962E+00,0.2942E+00,0.2919E+00,0.2895E+00,
     *0.2869E+00,0.2842E+00,0.2814E+00,0.2785E+00,0.2757E+00,
     *0.2728E+00,0.2699E+00,0.2670E+00,0.2643E+00,0.2615E+00,
     *0.2590E+00,0.2565E+00,0.2542E+00,0.2522E+00,0.2504E+00,
     *0.2490E+00,0.2479E+00,0.2473E+00,0.2472E+00,0.2477E+00,
     *0.2488E+00,0.2507E+00,0.2534E+00,0.2570E+00,0.2616E+00,
     *0.2673E+00,0.2743E+00,0.2826E+00,0.2925E+00,0.3040E+00,
     *0.3173E+00,0.3247E+00,0.3327E+00,0.3502E+00,0.3702E+00,
     *0.3928E+00,0.4183E+00,0.4471E+00,0.4794E+00,0.5156E+00,
     *0.5562E+00,0.6014E+00,0.6520E+00,0.7083E+00,0.7711E+00,
     *0.8412E+00,0.9192E+00,0.1006E+01,0.1104E+01,0.1212E+01,
     *0.1334E+01,0.1471E+01,0.1625E+01,0.1799E+01,0.1996E+01,
     *0.2221E+01,0.2479E+01,0.2776E+01,0.3120E+01,0.3521E+01,
     *0.3991E+01,0.4547E+01,0.5206E+01,0.5990E+01,0.6924E+01,
     *0.8032E+01,0.9334E+01,0.1084E+02,0.1253E+02,0.1434E+02,
     *0.1609E+02,0.1744E+02,0.1785E+02 /
        DATA ((PHR(i,j),j=1,83),i=20,20)/
     *0.3991E+00,0.3988E+00,0.3978E+00,0.3964E+00,0.3948E+00,
     *0.3929E+00,0.3906E+00,0.3879E+00,0.3847E+00,0.3812E+00,
     *0.3773E+00,0.3732E+00,0.3689E+00,0.3645E+00,0.3599E+00,
     *0.3552E+00,0.3504E+00,0.3457E+00,0.3409E+00,0.3363E+00,
     *0.3317E+00,0.3274E+00,0.3232E+00,0.3193E+00,0.3157E+00,
     *0.3125E+00,0.3098E+00,0.3076E+00,0.3059E+00,0.3049E+00,
     *0.3047E+00,0.3053E+00,0.3067E+00,0.3092E+00,0.3128E+00,
     *0.3175E+00,0.3236E+00,0.3312E+00,0.3403E+00,0.3511E+00,
     *0.3638E+00,0.3709E+00,0.3786E+00,0.3955E+00,0.4149E+00,
     *0.4369E+00,0.4618E+00,0.4899E+00,0.5214E+00,0.5566E+00,
     *0.5960E+00,0.6400E+00,0.6890E+00,0.7437E+00,0.8045E+00,
     *0.8724E+00,0.9480E+00,0.1033E+01,0.1127E+01,0.1233E+01,
     *0.1352E+01,0.1485E+01,0.1636E+01,0.1807E+01,0.2001E+01,
     *0.2222E+01,0.2475E+01,0.2764E+01,0.3097E+01,0.3479E+01,
     *0.3919E+01,0.4426E+01,0.5008E+01,0.5672E+01,0.6425E+01,
     *0.7267E+01,0.8194E+01,0.9184E+01,0.1020E+02,0.1118E+02,
     *0.1203E+02,0.1261E+02,0.1277E+02 /
c************** MIE (phase fun qh) ***************
        DATA ((QHR(i,j),j=1,83),i= 1, 1)/
     * 0.3388E-22, 0.2705E-02, 0.1324E-01, 0.2911E-01, 0.4717E-01,
     * 0.6492E-01, 0.8049E-01, 0.9251E-01, 0.1002E+00, 0.1033E+00,
     * 0.1023E+00, 0.9820E-01, 0.9197E-01, 0.8458E-01, 0.7677E-01,
     * 0.6906E-01, 0.6178E-01, 0.5510E-01, 0.4908E-01, 0.4371E-01,
     * 0.3894E-01, 0.3476E-01, 0.3108E-01, 0.2789E-01, 0.2512E-01,
     * 0.2270E-01, 0.2055E-01, 0.1865E-01, 0.1696E-01, 0.1549E-01,
     * 0.1422E-01, 0.1313E-01, 0.1218E-01, 0.1132E-01, 0.1057E-01,
     * 0.9939E-02, 0.9418E-02, 0.9008E-02, 0.8688E-02, 0.8454E-02,
     * 0.8315E-02, 0.8279E-02, 0.8274E-02, 0.8317E-02, 0.8427E-02,
     * 0.8611E-02, 0.8898E-02, 0.9317E-02, 0.9885E-02, 0.1060E-01,
     * 0.1144E-01, 0.1236E-01, 0.1335E-01, 0.1448E-01, 0.1579E-01,
     * 0.1730E-01, 0.1901E-01, 0.2089E-01, 0.2289E-01, 0.2500E-01,
     * 0.2724E-01, 0.2958E-01, 0.3201E-01, 0.3457E-01, 0.3722E-01,
     * 0.3991E-01, 0.4262E-01, 0.4526E-01, 0.4769E-01, 0.4990E-01,
     * 0.5190E-01, 0.5358E-01, 0.5490E-01, 0.5561E-01, 0.5517E-01,
     * 0.5310E-01, 0.4897E-01, 0.4243E-01, 0.3358E-01, 0.2348E-01,
     * 0.1324E-01, 0.4093E-02, 0.2630E-19 /
        DATA ((QHR(i,j),j=1,83),i= 2, 2)/
     * 0.4524E-21, 0.2675E-02, 0.1299E-01, 0.2843E-01, 0.4600E-01,
     * 0.6326E-01, 0.7840E-01, 0.9019E-01, 0.9788E-01, 0.1013E+00,
     * 0.1007E+00, 0.9713E-01, 0.9141E-01, 0.8445E-01, 0.7692E-01,
     * 0.6936E-01, 0.6210E-01, 0.5530E-01, 0.4908E-01, 0.4347E-01,
     * 0.3845E-01, 0.3399E-01, 0.3003E-01, 0.2650E-01, 0.2336E-01,
     * 0.2058E-01, 0.1810E-01, 0.1588E-01, 0.1389E-01, 0.1210E-01,
     * 0.1049E-01, 0.9040E-02, 0.7753E-02, 0.6579E-02, 0.5498E-02,
     * 0.4519E-02, 0.3644E-02, 0.2878E-02, 0.2215E-02, 0.1623E-02,
     * 0.1075E-02, 0.8190E-03, 0.5775E-03, 0.1801E-03,-0.7529E-04,
     *-0.2034E-03,-0.2525E-03,-0.2500E-03,-0.1807E-03,-0.4815E-05,
     * 0.3298E-03, 0.8693E-03, 0.1601E-02, 0.2449E-02, 0.3380E-02,
     * 0.4453E-02, 0.5747E-02, 0.7287E-02, 0.9066E-02, 0.1106E-01,
     * 0.1320E-01, 0.1545E-01, 0.1787E-01, 0.2050E-01, 0.2332E-01,
     * 0.2633E-01, 0.2944E-01, 0.3244E-01, 0.3529E-01, 0.3801E-01,
     * 0.4048E-01, 0.4266E-01, 0.4448E-01, 0.4553E-01, 0.4543E-01,
     * 0.4400E-01, 0.4066E-01, 0.3529E-01, 0.2826E-01, 0.1954E-01,
     * 0.1043E-01, 0.3119E-02, 0.8522E-20 /
        DATA ((QHR(i,j),j=1,83),i= 3, 3)/
     * 0.1156E-20, 0.2647E-02, 0.1288E-01, 0.2824E-01, 0.4582E-01,
     * 0.6312E-01, 0.7832E-01, 0.9019E-01, 0.9795E-01, 0.1013E+00,
     * 0.1008E+00, 0.9717E-01, 0.9146E-01, 0.8452E-01, 0.7705E-01,
     * 0.6952E-01, 0.6226E-01, 0.5544E-01, 0.4917E-01, 0.4350E-01,
     * 0.3843E-01, 0.3390E-01, 0.2987E-01, 0.2624E-01, 0.2298E-01,
     * 0.2005E-01, 0.1747E-01, 0.1518E-01, 0.1315E-01, 0.1131E-01,
     * 0.9615E-02, 0.8054E-02, 0.6657E-02, 0.5420E-02, 0.4300E-02,
     * 0.3277E-02, 0.2335E-02, 0.1467E-02, 0.6896E-03, 0.8981E-07,
     *-0.6248E-03,-0.9151E-03,-0.1198E-02,-0.1684E-02,-0.2032E-02,
     *-0.2242E-02,-0.2364E-02,-0.2436E-02,-0.2463E-02,-0.2424E-02,
     *-0.2243E-02,-0.1825E-02,-0.1160E-02,-0.3305E-03, 0.5932E-03,
     * 0.1609E-02, 0.2774E-02, 0.4151E-02, 0.5802E-02, 0.7710E-02,
     * 0.9820E-02, 0.1213E-01, 0.1464E-01, 0.1728E-01, 0.2005E-01,
     * 0.2297E-01, 0.2595E-01, 0.2892E-01, 0.3194E-01, 0.3488E-01,
     * 0.3759E-01, 0.4001E-01, 0.4182E-01, 0.4259E-01, 0.4208E-01,
     * 0.4009E-01, 0.3629E-01, 0.3098E-01, 0.2458E-01, 0.1666E-01,
     * 0.8573E-02, 0.2603E-02, 0.2928E-19 /
        DATA ((QHR(i,j),j=1,83),i= 4, 4)/
     *-0.4206E-21, 0.2749E-02, 0.1315E-01, 0.2850E-01, 0.4587E-01,
     * 0.6291E-01, 0.7786E-01, 0.8953E-01, 0.9722E-01, 0.1007E+00,
     * 0.1003E+00, 0.9695E-01, 0.9147E-01, 0.8470E-01, 0.7729E-01,
     * 0.6979E-01, 0.6249E-01, 0.5559E-01, 0.4919E-01, 0.4336E-01,
     * 0.3811E-01, 0.3340E-01, 0.2917E-01, 0.2535E-01, 0.2190E-01,
     * 0.1881E-01, 0.1603E-01, 0.1352E-01, 0.1125E-01, 0.9161E-02,
     * 0.7240E-02, 0.5479E-02, 0.3894E-02, 0.2435E-02, 0.1059E-02,
     *-0.2257E-03,-0.1414E-02,-0.2500E-02,-0.3482E-02,-0.4388E-02,
     *-0.5269E-02,-0.5701E-02,-0.6128E-02,-0.6891E-02,-0.7481E-02,
     *-0.7917E-02,-0.8283E-02,-0.8634E-02,-0.8953E-02,-0.9183E-02,
     *-0.9235E-02,-0.9017E-02,-0.8550E-02,-0.7968E-02,-0.7338E-02,
     *-0.6589E-02,-0.5593E-02,-0.4297E-02,-0.2697E-02,-0.8211E-03,
     * 0.1227E-02, 0.3444E-02, 0.5887E-02, 0.8595E-02, 0.1154E-01,
     * 0.1478E-01, 0.1818E-01, 0.2150E-01, 0.2474E-01, 0.2793E-01,
     * 0.3089E-01, 0.3357E-01, 0.3595E-01, 0.3750E-01, 0.3791E-01,
     * 0.3714E-01, 0.3449E-01, 0.3004E-01, 0.2432E-01, 0.1679E-01,
     * 0.8710E-02, 0.2571E-02, 0.2363E-19 /
        DATA ((QHR(i,j),j=1,83),i= 5, 5)/
     *-0.4642E-22, 0.2556E-02, 0.1228E-01, 0.2679E-01, 0.4345E-01,
     * 0.6001E-01, 0.7472E-01, 0.8634E-01, 0.9402E-01, 0.9753E-01,
     * 0.9730E-01, 0.9412E-01, 0.8888E-01, 0.8243E-01, 0.7540E-01,
     * 0.6823E-01, 0.6118E-01, 0.5445E-01, 0.4815E-01, 0.4235E-01,
     * 0.3707E-01, 0.3226E-01, 0.2790E-01, 0.2393E-01, 0.2031E-01,
     * 0.1701E-01, 0.1404E-01, 0.1136E-01, 0.8930E-02, 0.6697E-02,
     * 0.4618E-02, 0.2658E-02, 0.8311E-03,-0.8244E-03,-0.2341E-02,
     *-0.3768E-02,-0.5133E-02,-0.6448E-02,-0.7699E-02,-0.8860E-02,
     *-0.9916E-02,-0.1041E-01,-0.1088E-01,-0.1179E-01,-0.1266E-01,
     *-0.1345E-01,-0.1412E-01,-0.1469E-01,-0.1514E-01,-0.1550E-01,
     *-0.1578E-01,-0.1594E-01,-0.1592E-01,-0.1563E-01,-0.1510E-01,
     *-0.1440E-01,-0.1360E-01,-0.1263E-01,-0.1141E-01,-0.9913E-02,
     *-0.8059E-02,-0.5823E-02,-0.3285E-02,-0.5974E-03, 0.2233E-02,
     * 0.5150E-02, 0.8199E-02, 0.1154E-01, 0.1528E-01, 0.1913E-01,
     * 0.2285E-01, 0.2626E-01, 0.2879E-01, 0.3028E-01, 0.3065E-01,
     * 0.2939E-01, 0.2662E-01, 0.2267E-01, 0.1759E-01, 0.1192E-01,
     * 0.6591E-02, 0.2086E-02, 0.2318E-19 /
        DATA ((QHR(i,j),j=1,83),i= 6, 6)/
     * 0.1625E-22, 0.2573E-02, 0.1220E-01, 0.2625E-01, 0.4214E-01,
     * 0.5787E-01, 0.7184E-01, 0.8289E-01, 0.9034E-01, 0.9399E-01,
     * 0.9414E-01, 0.9147E-01, 0.8675E-01, 0.8068E-01, 0.7386E-01,
     * 0.6680E-01, 0.5986E-01, 0.5322E-01, 0.4700E-01, 0.4123E-01,
     * 0.3592E-01, 0.3107E-01, 0.2665E-01, 0.2265E-01, 0.1904E-01,
     * 0.1576E-01, 0.1275E-01, 0.9934E-02, 0.7307E-02, 0.4879E-02,
     * 0.2661E-02, 0.6367E-03,-0.1255E-02,-0.3091E-02,-0.4850E-02,
     *-0.6497E-02,-0.8032E-02,-0.9461E-02,-0.1081E-01,-0.1211E-01,
     *-0.1337E-01,-0.1398E-01,-0.1457E-01,-0.1566E-01,-0.1668E-01,
     *-0.1763E-01,-0.1853E-01,-0.1934E-01,-0.2002E-01,-0.2054E-01,
     *-0.2091E-01,-0.2115E-01,-0.2127E-01,-0.2128E-01,-0.2112E-01,
     *-0.2072E-01,-0.1999E-01,-0.1894E-01,-0.1763E-01,-0.1604E-01,
     *-0.1424E-01,-0.1226E-01,-0.1000E-01,-0.7301E-02,-0.4210E-02,
     *-0.7418E-03, 0.3032E-02, 0.6862E-02, 0.1054E-01, 0.1419E-01,
     * 0.1776E-01, 0.2117E-01, 0.2459E-01, 0.2764E-01, 0.2974E-01,
     * 0.3066E-01, 0.2970E-01, 0.2647E-01, 0.2148E-01, 0.1532E-01,
     * 0.8717E-02, 0.2570E-02, 0.2508E-19 /
        DATA ((QHR(i,j),j=1,83),i= 7, 7)/
     * 0.5125E-21, 0.2459E-02, 0.1162E-01, 0.2501E-01, 0.4023E-01,
     * 0.5535E-01, 0.6887E-01, 0.7967E-01, 0.8708E-01, 0.9086E-01,
     * 0.9122E-01, 0.8882E-01, 0.8440E-01, 0.7862E-01, 0.7208E-01,
     * 0.6526E-01, 0.5848E-01, 0.5192E-01, 0.4570E-01, 0.3991E-01,
     * 0.3457E-01, 0.2967E-01, 0.2519E-01, 0.2107E-01, 0.1728E-01,
     * 0.1382E-01, 0.1064E-01, 0.7682E-02, 0.4928E-02, 0.2351E-02,
     *-0.6637E-04,-0.2319E-02,-0.4410E-02,-0.6406E-02,-0.8340E-02,
     *-0.1019E-01,-0.1195E-01,-0.1361E-01,-0.1518E-01,-0.1668E-01,
     *-0.1818E-01,-0.1892E-01,-0.1966E-01,-0.2106E-01,-0.2230E-01,
     *-0.2341E-01,-0.2447E-01,-0.2552E-01,-0.2651E-01,-0.2740E-01,
     *-0.2810E-01,-0.2856E-01,-0.2879E-01,-0.2890E-01,-0.2894E-01,
     *-0.2880E-01,-0.2833E-01,-0.2751E-01,-0.2636E-01,-0.2487E-01,
     *-0.2313E-01,-0.2114E-01,-0.1883E-01,-0.1609E-01,-0.1296E-01,
     *-0.9384E-02,-0.5490E-02,-0.1521E-02, 0.2468E-02, 0.6546E-02,
     * 0.1053E-01, 0.1434E-01, 0.1803E-01, 0.2113E-01, 0.2331E-01,
     * 0.2455E-01, 0.2408E-01, 0.2180E-01, 0.1828E-01, 0.1307E-01,
     * 0.7038E-02, 0.2041E-02, 0.1995E-19 /
        DATA ((QHR(i,j),j=1,83),i= 8, 8)/
     *-0.3431E-22, 0.2397E-02, 0.1118E-01, 0.2394E-01, 0.3859E-01,
     * 0.5328E-01, 0.6650E-01, 0.7715E-01, 0.8439E-01, 0.8803E-01,
     * 0.8844E-01, 0.8620E-01, 0.8197E-01, 0.7644E-01, 0.7019E-01,
     * 0.6359E-01, 0.5697E-01, 0.5056E-01, 0.4446E-01, 0.3871E-01,
     * 0.3329E-01, 0.2823E-01, 0.2353E-01, 0.1923E-01, 0.1528E-01,
     * 0.1161E-01, 0.8164E-02, 0.4941E-02, 0.1932E-02,-0.8723E-03,
     *-0.3485E-02,-0.5947E-02,-0.8331E-02,-0.1062E-01,-0.1279E-01,
     *-0.1487E-01,-0.1687E-01,-0.1880E-01,-0.2068E-01,-0.2250E-01,
     *-0.2423E-01,-0.2505E-01,-0.2585E-01,-0.2742E-01,-0.2903E-01,
     *-0.3062E-01,-0.3210E-01,-0.3340E-01,-0.3454E-01,-0.3552E-01,
     *-0.3636E-01,-0.3719E-01,-0.3801E-01,-0.3861E-01,-0.3884E-01,
     *-0.3868E-01,-0.3827E-01,-0.3766E-01,-0.3684E-01,-0.3575E-01,
     *-0.3421E-01,-0.3221E-01,-0.2979E-01,-0.2700E-01,-0.2382E-01,
     *-0.2038E-01,-0.1664E-01,-0.1243E-01,-0.7940E-02,-0.3224E-02,
     * 0.1704E-02, 0.6477E-02, 0.1076E-01, 0.1462E-01, 0.1760E-01,
     * 0.1876E-01, 0.1840E-01, 0.1628E-01, 0.1222E-01, 0.9020E-02,
     * 0.6669E-02, 0.2401E-02,-0.4543E-20 /
        DATA ((QHR(i,j),j=1,83),i= 9, 9)/
     * 0.5428E-21, 0.2160E-02, 0.1018E-01, 0.2199E-01, 0.3564E-01,
     * 0.4949E-01, 0.6216E-01, 0.7251E-01, 0.7971E-01, 0.8344E-01,
     * 0.8402E-01, 0.8198E-01, 0.7805E-01, 0.7290E-01, 0.6704E-01,
     * 0.6082E-01, 0.5446E-01, 0.4816E-01, 0.4206E-01, 0.3627E-01,
     * 0.3084E-01, 0.2575E-01, 0.2099E-01, 0.1652E-01, 0.1233E-01,
     * 0.8374E-02, 0.4708E-02, 0.1307E-02,-0.1890E-02,-0.4921E-02,
     *-0.7821E-02,-0.1063E-01,-0.1333E-01,-0.1588E-01,-0.1830E-01,
     *-0.2066E-01,-0.2297E-01,-0.2525E-01,-0.2748E-01,-0.2965E-01,
     *-0.3172E-01,-0.3272E-01,-0.3372E-01,-0.3568E-01,-0.3761E-01,
     *-0.3945E-01,-0.4119E-01,-0.4283E-01,-0.4435E-01,-0.4579E-01,
     *-0.4714E-01,-0.4834E-01,-0.4932E-01,-0.4999E-01,-0.5036E-01,
     *-0.5054E-01,-0.5054E-01,-0.5029E-01,-0.4966E-01,-0.4864E-01,
     *-0.4712E-01,-0.4506E-01,-0.4254E-01,-0.3967E-01,-0.3646E-01,
     *-0.3293E-01,-0.2902E-01,-0.2457E-01,-0.1945E-01,-0.1405E-01,
     *-0.8622E-02,-0.3265E-02, 0.1392E-02, 0.5168E-02, 0.8102E-02,
     * 0.9738E-02, 0.1022E-01, 0.9905E-02, 0.8604E-02, 0.6227E-02,
     * 0.3512E-02, 0.1108E-02, 0.1924E-19 /
        DATA ((QHR(i,j),j=1,83),i=10,10)/
     *-0.3477E-21, 0.2034E-02, 0.9499E-02, 0.2036E-01, 0.3281E-01,
     * 0.4547E-01, 0.5712E-01, 0.6669E-01, 0.7353E-01, 0.7731E-01,
     * 0.7815E-01, 0.7657E-01, 0.7319E-01, 0.6854E-01, 0.6305E-01,
     * 0.5711E-01, 0.5099E-01, 0.4485E-01, 0.3885E-01, 0.3311E-01,
     * 0.2767E-01, 0.2255E-01, 0.1772E-01, 0.1313E-01, 0.8757E-02,
     * 0.4622E-02, 0.7392E-03,-0.2913E-02,-0.6355E-02,-0.9660E-02,
     *-0.1289E-01,-0.1603E-01,-0.1901E-01,-0.2186E-01,-0.2463E-01,
     *-0.2736E-01,-0.3004E-01,-0.3268E-01,-0.3525E-01,-0.3774E-01,
     *-0.4020E-01,-0.4143E-01,-0.4268E-01,-0.4512E-01,-0.4739E-01,
     *-0.4951E-01,-0.5156E-01,-0.5360E-01,-0.5561E-01,-0.5757E-01,
     *-0.5935E-01,-0.6080E-01,-0.6189E-01,-0.6279E-01,-0.6358E-01,
     *-0.6419E-01,-0.6450E-01,-0.6438E-01,-0.6376E-01,-0.6267E-01,
     *-0.6117E-01,-0.5918E-01,-0.5666E-01,-0.5367E-01,-0.5018E-01,
     *-0.4604E-01,-0.4141E-01,-0.3642E-01,-0.3102E-01,-0.2535E-01,
     *-0.1955E-01,-0.1368E-01,-0.7927E-02,-0.2870E-02, 0.1242E-02,
     * 0.4428E-02, 0.6122E-02, 0.6821E-02, 0.7160E-02, 0.5520E-02,
     * 0.2549E-02, 0.8291E-03,-0.1758E-19 /
        DATA ((QHR(i,j),j=1,83),i=11,11)/
     * 0.8851E-21, 0.1859E-02, 0.8720E-02, 0.1878E-01, 0.3043E-01,
     * 0.4237E-01, 0.5343E-01, 0.6265E-01, 0.6924E-01, 0.7287E-01,
     * 0.7377E-01, 0.7232E-01, 0.6910E-01, 0.6470E-01, 0.5955E-01,
     * 0.5392E-01, 0.4805E-01, 0.4211E-01, 0.3624E-01, 0.3055E-01,
     * 0.2510E-01, 0.1989E-01, 0.1493E-01, 0.1020E-01, 0.5681E-02,
     * 0.1362E-02,-0.2723E-02,-0.6589E-02,-0.1029E-01,-0.1385E-01,
     *-0.1729E-01,-0.2066E-01,-0.2394E-01,-0.2709E-01,-0.3014E-01,
     *-0.3314E-01,-0.3610E-01,-0.3903E-01,-0.4192E-01,-0.4476E-01,
     *-0.4752E-01,-0.4886E-01,-0.5020E-01,-0.5284E-01,-0.5546E-01,
     *-0.5801E-01,-0.6046E-01,-0.6278E-01,-0.6498E-01,-0.6706E-01,
     *-0.6903E-01,-0.7085E-01,-0.7245E-01,-0.7371E-01,-0.7462E-01,
     *-0.7526E-01,-0.7566E-01,-0.7574E-01,-0.7537E-01,-0.7453E-01,
     *-0.7312E-01,-0.7107E-01,-0.6842E-01,-0.6529E-01,-0.6165E-01,
     *-0.5757E-01,-0.5295E-01,-0.4765E-01,-0.4154E-01,-0.3501E-01,
     *-0.2830E-01,-0.2156E-01,-0.1537E-01,-0.9855E-02,-0.4989E-02,
     *-0.1263E-02, 0.1438E-02, 0.3321E-02, 0.4031E-02, 0.3630E-02,
     * 0.2530E-02, 0.8873E-03, 0.1537E-19 /
        DATA ((QHR(i,j),j=1,83),i=12,12)/
     *-0.1670E-21, 0.1944E-02, 0.8894E-02, 0.1865E-01, 0.2968E-01,
     * 0.4087E-01, 0.5121E-01, 0.5986E-01, 0.6614E-01, 0.6972E-01,
     * 0.7074E-01, 0.6963E-01, 0.6680E-01, 0.6265E-01, 0.5758E-01,
     * 0.5196E-01, 0.4612E-01, 0.4027E-01, 0.3450E-01, 0.2886E-01,
     * 0.2337E-01, 0.1809E-01, 0.1304E-01, 0.8231E-02, 0.3693E-02,
     *-0.6171E-03,-0.4788E-02,-0.8846E-02,-0.1278E-01,-0.1657E-01,
     *-0.2018E-01,-0.2364E-01,-0.2705E-01,-0.3045E-01,-0.3378E-01,
     *-0.3701E-01,-0.4015E-01,-0.4324E-01,-0.4629E-01,-0.4933E-01,
     *-0.5233E-01,-0.5380E-01,-0.5523E-01,-0.5803E-01,-0.6083E-01,
     *-0.6364E-01,-0.6638E-01,-0.6896E-01,-0.7134E-01,-0.7353E-01,
     *-0.7556E-01,-0.7749E-01,-0.7926E-01,-0.8082E-01,-0.8205E-01,
     *-0.8287E-01,-0.8326E-01,-0.8319E-01,-0.8271E-01,-0.8176E-01,
     *-0.8032E-01,-0.7839E-01,-0.7590E-01,-0.7263E-01,-0.6863E-01,
     *-0.6393E-01,-0.5859E-01,-0.5273E-01,-0.4664E-01,-0.4024E-01,
     *-0.3349E-01,-0.2651E-01,-0.1924E-01,-0.1195E-01,-0.5381E-02,
     * 0.1154E-03, 0.4222E-02, 0.6402E-02, 0.6872E-02, 0.6538E-02,
     * 0.5064E-02, 0.1805E-02, 0.9720E-20 /
        DATA ((QHR(i,j),j=1,83),i=13,13)/
     * 0.5713E-21, 0.1640E-02, 0.7646E-02, 0.1635E-01, 0.2638E-01,
     * 0.3671E-01, 0.4640E-01, 0.5457E-01, 0.6050E-01, 0.6385E-01,
     * 0.6477E-01, 0.6359E-01, 0.6079E-01, 0.5688E-01, 0.5218E-01,
     * 0.4696E-01, 0.4140E-01, 0.3567E-01, 0.2990E-01, 0.2421E-01,
     * 0.1867E-01, 0.1328E-01, 0.8065E-02, 0.3014E-02,-0.1891E-02,
     *-0.6651E-02,-0.1122E-01,-0.1560E-01,-0.1985E-01,-0.2400E-01,
     *-0.2805E-01,-0.3205E-01,-0.3599E-01,-0.3980E-01,-0.4353E-01,
     *-0.4721E-01,-0.5087E-01,-0.5451E-01,-0.5812E-01,-0.6167E-01,
     *-0.6515E-01,-0.6685E-01,-0.6855E-01,-0.7192E-01,-0.7525E-01,
     *-0.7848E-01,-0.8160E-01,-0.8460E-01,-0.8744E-01,-0.9016E-01,
     *-0.9273E-01,-0.9511E-01,-0.9719E-01,-0.9889E-01,-0.1002E+00,
     *-0.1012E+00,-0.1019E+00,-0.1022E+00,-0.1019E+00,-0.1010E+00,
     *-0.9950E-01,-0.9723E-01,-0.9427E-01,-0.9069E-01,-0.8647E-01,
     *-0.8165E-01,-0.7613E-01,-0.6981E-01,-0.6258E-01,-0.5483E-01,
     *-0.4683E-01,-0.3863E-01,-0.3081E-01,-0.2360E-01,-0.1695E-01,
     *-0.1129E-01,-0.6603E-02,-0.2679E-02, 0.6384E-04, 0.1208E-02,
     * 0.1158E-02, 0.4679E-03, 0.3459E-20 /
        DATA ((QHR(i,j),j=1,83),i=14,14)/
     *-0.3391E-21, 0.1558E-02, 0.7150E-02, 0.1507E-01, 0.2396E-01,
     * 0.3316E-01, 0.4196E-01, 0.4932E-01, 0.5460E-01, 0.5752E-01,
     * 0.5818E-01, 0.5695E-01, 0.5431E-01, 0.5058E-01, 0.4604E-01,
     * 0.4093E-01, 0.3542E-01, 0.2967E-01, 0.2380E-01, 0.1795E-01,
     * 0.1220E-01, 0.6539E-02, 0.9936E-03,-0.4447E-02,-0.9836E-02,
     *-0.1513E-01,-0.2026E-01,-0.2521E-01,-0.3004E-01,-0.3479E-01,
     *-0.3953E-01,-0.4426E-01,-0.4888E-01,-0.5337E-01,-0.5779E-01,
     *-0.6219E-01,-0.6658E-01,-0.7095E-01,-0.7529E-01,-0.7954E-01,
     *-0.8370E-01,-0.8577E-01,-0.8785E-01,-0.9198E-01,-0.9597E-01,
     *-0.9978E-01,-0.1035E+00,-0.1070E+00,-0.1105E+00,-0.1138E+00,
     *-0.1170E+00,-0.1197E+00,-0.1220E+00,-0.1239E+00,-0.1254E+00,
     *-0.1267E+00,-0.1275E+00,-0.1278E+00,-0.1273E+00,-0.1261E+00,
     *-0.1242E+00,-0.1215E+00,-0.1180E+00,-0.1138E+00,-0.1089E+00,
     *-0.1030E+00,-0.9632E-01,-0.8884E-01,-0.8055E-01,-0.7182E-01,
     *-0.6271E-01,-0.5320E-01,-0.4376E-01,-0.3485E-01,-0.2659E-01,
     *-0.1935E-01,-0.1351E-01,-0.8481E-02,-0.3919E-02,-0.2001E-02,
     *-0.1903E-02,-0.4805E-03,-0.1251E-20 /
        DATA ((QHR(i,j),j=1,83),i=15,15)/
     *-0.1315E-21, 0.1259E-02, 0.5558E-02, 0.1106E-01, 0.1676E-01,
     * 0.2214E-01, 0.2691E-01, 0.3081E-01, 0.3335E-01, 0.3421E-01,
     * 0.3352E-01, 0.3156E-01, 0.2855E-01, 0.2461E-01, 0.1986E-01,
     * 0.1447E-01, 0.8665E-02, 0.2619E-02,-0.3626E-02,-0.1010E-01,
     *-0.1679E-01,-0.2363E-01,-0.3055E-01,-0.3751E-01,-0.4444E-01,
     *-0.5139E-01,-0.5843E-01,-0.6553E-01,-0.7263E-01,-0.7968E-01,
     *-0.8668E-01,-0.9364E-01,-0.1006E+00,-0.1076E+00,-0.1146E+00,
     *-0.1215E+00,-0.1283E+00,-0.1350E+00,-0.1416E+00,-0.1482E+00,
     *-0.1547E+00,-0.1578E+00,-0.1609E+00,-0.1670E+00,-0.1729E+00,
     *-0.1787E+00,-0.1842E+00,-0.1893E+00,-0.1940E+00,-0.1983E+00,
     *-0.2021E+00,-0.2055E+00,-0.2084E+00,-0.2109E+00,-0.2125E+00,
     *-0.2132E+00,-0.2130E+00,-0.2120E+00,-0.2102E+00,-0.2075E+00,
     *-0.2036E+00,-0.1986E+00,-0.1925E+00,-0.1852E+00,-0.1768E+00,
     *-0.1672E+00,-0.1564E+00,-0.1447E+00,-0.1322E+00,-0.1193E+00,
     *-0.1056E+00,-0.9127E-01,-0.7654E-01,-0.6181E-01,-0.4789E-01,
     *-0.3535E-01,-0.2416E-01,-0.1481E-01,-0.7809E-02,-0.2425E-02,
     * 0.7463E-03, 0.6630E-03,-0.2429E-19 /
        DATA ((QHR(i,j),j=1,83),i=16,16)/
     * 0.2669E-21, 0.2490E-03, 0.1557E-02, 0.3470E-02, 0.4990E-02,
     * 0.5817E-02, 0.5650E-02, 0.4433E-02, 0.2410E-02,-0.3422E-03,
     *-0.3735E-02,-0.7634E-02,-0.1195E-01,-0.1662E-01,-0.2170E-01,
     *-0.2725E-01,-0.3320E-01,-0.3944E-01,-0.4594E-01,-0.5273E-01,
     *-0.5979E-01,-0.6710E-01,-0.7461E-01,-0.8231E-01,-0.9016E-01,
     *-0.9814E-01,-0.1063E+00,-0.1145E+00,-0.1230E+00,-0.1314E+00,
     *-0.1400E+00,-0.1487E+00,-0.1574E+00,-0.1662E+00,-0.1749E+00,
     *-0.1837E+00,-0.1925E+00,-0.2012E+00,-0.2099E+00,-0.2185E+00,
     *-0.2270E+00,-0.2311E+00,-0.2352E+00,-0.2433E+00,-0.2512E+00,
     *-0.2588E+00,-0.2660E+00,-0.2728E+00,-0.2792E+00,-0.2851E+00,
     *-0.2903E+00,-0.2950E+00,-0.2989E+00,-0.3021E+00,-0.3043E+00,
     *-0.3055E+00,-0.3056E+00,-0.3046E+00,-0.3023E+00,-0.2987E+00,
     *-0.2936E+00,-0.2870E+00,-0.2790E+00,-0.2692E+00,-0.2577E+00,
     *-0.2446E+00,-0.2300E+00,-0.2139E+00,-0.1965E+00,-0.1777E+00,
     *-0.1578E+00,-0.1373E+00,-0.1168E+00,-0.9640E-01,-0.7634E-01,
     *-0.5701E-01,-0.3961E-01,-0.2516E-01,-0.1338E-01,-0.5261E-02,
     *-0.1734E-02,-0.3817E-03,-0.7847E-20 /
        DATA ((QHR(i,j),j=1,83),i=17,17)/
     * 0.3473E-21, 0.9441E-04, 0.6895E-03, 0.1715E-02, 0.2543E-02,
     * 0.2424E-02, 0.1184E-02,-0.1028E-02,-0.3976E-02,-0.7404E-02,
     *-0.1123E-01,-0.1541E-01,-0.1992E-01,-0.2481E-01,-0.3006E-01,
     *-0.3562E-01,-0.4158E-01,-0.4796E-01,-0.5468E-01,-0.6169E-01,
     *-0.6896E-01,-0.7648E-01,-0.8426E-01,-0.9226E-01,-0.1004E+00,
     *-0.1088E+00,-0.1174E+00,-0.1261E+00,-0.1350E+00,-0.1440E+00,
     *-0.1531E+00,-0.1622E+00,-0.1714E+00,-0.1807E+00,-0.1901E+00,
     *-0.1994E+00,-0.2087E+00,-0.2180E+00,-0.2271E+00,-0.2362E+00,
     *-0.2451E+00,-0.2495E+00,-0.2538E+00,-0.2623E+00,-0.2706E+00,
     *-0.2785E+00,-0.2860E+00,-0.2931E+00,-0.2998E+00,-0.3058E+00,
     *-0.3113E+00,-0.3160E+00,-0.3199E+00,-0.3229E+00,-0.3250E+00,
     *-0.3261E+00,-0.3261E+00,-0.3247E+00,-0.3220E+00,-0.3179E+00,
     *-0.3123E+00,-0.3052E+00,-0.2963E+00,-0.2858E+00,-0.2735E+00,
     *-0.2595E+00,-0.2438E+00,-0.2265E+00,-0.2078E+00,-0.1878E+00,
     *-0.1669E+00,-0.1450E+00,-0.1230E+00,-0.1012E+00,-0.8006E-01,
     *-0.6003E-01,-0.4183E-01,-0.2630E-01,-0.1460E-01,-0.6345E-02,
     *-0.1145E-02, 0.1771E-03, 0.4417E-20 /
        DATA ((QHR(i,j),j=1,83),i=18,18)/
     * 0.2287E-22,-0.7661E-04,-0.1820E-03,-0.3819E-03,-0.1410E-02,
     *-0.3696E-02,-0.7124E-02,-0.1130E-01,-0.1590E-01,-0.2082E-01,
     *-0.2596E-01,-0.3131E-01,-0.3684E-01,-0.4254E-01,-0.4843E-01,
     *-0.5451E-01,-0.6080E-01,-0.6736E-01,-0.7417E-01,-0.8127E-01,
     *-0.8867E-01,-0.9636E-01,-0.1044E+00,-0.1127E+00,-0.1213E+00,
     *-0.1301E+00,-0.1392E+00,-0.1486E+00,-0.1581E+00,-0.1679E+00,
     *-0.1778E+00,-0.1878E+00,-0.1980E+00,-0.2082E+00,-0.2185E+00,
     *-0.2289E+00,-0.2392E+00,-0.2496E+00,-0.2598E+00,-0.2699E+00,
     *-0.2799E+00,-0.2849E+00,-0.2897E+00,-0.2993E+00,-0.3086E+00,
     *-0.3175E+00,-0.3260E+00,-0.3340E+00,-0.3415E+00,-0.3483E+00,
     *-0.3545E+00,-0.3600E+00,-0.3645E+00,-0.3682E+00,-0.3708E+00,
     *-0.3723E+00,-0.3725E+00,-0.3714E+00,-0.3689E+00,-0.3649E+00,
     *-0.3593E+00,-0.3519E+00,-0.3428E+00,-0.3318E+00,-0.3188E+00,
     *-0.3039E+00,-0.2870E+00,-0.2682E+00,-0.2474E+00,-0.2249E+00,
     *-0.2008E+00,-0.1755E+00,-0.1495E+00,-0.1230E+00,-0.9693E-01,
     *-0.7212E-01,-0.4973E-01,-0.3077E-01,-0.1595E-01,-0.6038E-02,
     *-0.1019E-02, 0.1302E-03,-0.4145E-21 /
        DATA ((QHR(i,j),j=1,83),i=19,19)/
     *-0.1316E-21, 0.1287E-04,-0.7324E-04,-0.7375E-03,-0.2397E-02,
     *-0.4972E-02,-0.8190E-02,-0.1191E-01,-0.1606E-01,-0.2061E-01,
     *-0.2556E-01,-0.3088E-01,-0.3658E-01,-0.4264E-01,-0.4903E-01,
     *-0.5574E-01,-0.6275E-01,-0.7004E-01,-0.7761E-01,-0.8543E-01,
     *-0.9352E-01,-0.1018E+00,-0.1104E+00,-0.1192E+00,-0.1283E+00,
     *-0.1376E+00,-0.1471E+00,-0.1569E+00,-0.1668E+00,-0.1769E+00,
     *-0.1872E+00,-0.1976E+00,-0.2082E+00,-0.2188E+00,-0.2294E+00,
     *-0.2401E+00,-0.2508E+00,-0.2614E+00,-0.2719E+00,-0.2823E+00,
     *-0.2925E+00,-0.2975E+00,-0.3025E+00,-0.3122E+00,-0.3216E+00,
     *-0.3305E+00,-0.3391E+00,-0.3472E+00,-0.3546E+00,-0.3615E+00,
     *-0.3677E+00,-0.3730E+00,-0.3776E+00,-0.3812E+00,-0.3838E+00,
     *-0.3854E+00,-0.3857E+00,-0.3849E+00,-0.3826E+00,-0.3790E+00,
     *-0.3739E+00,-0.3673E+00,-0.3589E+00,-0.3489E+00,-0.3371E+00,
     *-0.3234E+00,-0.3078E+00,-0.2903E+00,-0.2709E+00,-0.2495E+00,
     *-0.2262E+00,-0.2013E+00,-0.1747E+00,-0.1470E+00,-0.1187E+00,
     *-0.9077E-01,-0.6426E-01,-0.4063E-01,-0.2163E-01,-0.8394E-02,
     *-0.1355E-02, 0.2122E-03, 0.3172E-21 /
        DATA ((QHR(i,j),j=1,83),i=20,20)/
     * 0.1171E-21,-0.1182E-03,-0.6476E-03,-0.1734E-02,-0.3588E-02,
     *-0.6341E-02,-0.9982E-02,-0.1441E-01,-0.1953E-01,-0.2524E-01,
     *-0.3147E-01,-0.3817E-01,-0.4530E-01,-0.5285E-01,-0.6078E-01,
     *-0.6908E-01,-0.7774E-01,-0.8673E-01,-0.9606E-01,-0.1057E+00,
     *-0.1156E+00,-0.1258E+00,-0.1363E+00,-0.1470E+00,-0.1579E+00,
     *-0.1690E+00,-0.1802E+00,-0.1915E+00,-0.2029E+00,-0.2144E+00,
     *-0.2258E+00,-0.2372E+00,-0.2485E+00,-0.2597E+00,-0.2708E+00,
     *-0.2816E+00,-0.2922E+00,-0.3025E+00,-0.3125E+00,-0.3220E+00,
     *-0.3312E+00,-0.3356E+00,-0.3398E+00,-0.3479E+00,-0.3555E+00,
     *-0.3624E+00,-0.3687E+00,-0.3742E+00,-0.3790E+00,-0.3830E+00,
     *-0.3861E+00,-0.3884E+00,-0.3897E+00,-0.3900E+00,-0.3893E+00,
     *-0.3875E+00,-0.3846E+00,-0.3806E+00,-0.3755E+00,-0.3691E+00,
     *-0.3615E+00,-0.3526E+00,-0.3424E+00,-0.3308E+00,-0.3178E+00,
     *-0.3034E+00,-0.2875E+00,-0.2702E+00,-0.2514E+00,-0.2310E+00,
     *-0.2093E+00,-0.1864E+00,-0.1624E+00,-0.1377E+00,-0.1128E+00,
     *-0.8848E-01,-0.6550E-01,-0.4484E-01,-0.2749E-01,-0.1423E-01,
     *-0.5446E-02,-0.9621E-03, 0.1176E-19 /
c************** MIE (phase fun uh) ***************
        DATA ((UHR(i,j),j=1,83),i= 1, 1)/
     *-0.3494E+00,-0.3431E+00,-0.3173E+00,-0.2772E+00,-0.2303E+00,
     *-0.1834E+00,-0.1408E+00,-0.1042E+00,-0.7359E-01,-0.4855E-01,
     *-0.2835E-01,-0.1232E-01, 0.1890E-03, 0.9855E-02, 0.1727E-01,
     * 0.2297E-01, 0.2739E-01, 0.3090E-01, 0.3380E-01, 0.3630E-01,
     * 0.3857E-01, 0.4074E-01, 0.4290E-01, 0.4513E-01, 0.4753E-01,
     * 0.5015E-01, 0.5307E-01, 0.5632E-01, 0.5992E-01, 0.6392E-01,
     * 0.6836E-01, 0.7330E-01, 0.7882E-01, 0.8499E-01, 0.9188E-01,
     * 0.9958E-01, 0.1082E+00, 0.1177E+00, 0.1283E+00, 0.1402E+00,
     * 0.1535E+00, 0.1607E+00, 0.1683E+00, 0.1850E+00, 0.2036E+00,
     * 0.2244E+00, 0.2478E+00, 0.2741E+00, 0.3037E+00, 0.3371E+00,
     * 0.3747E+00, 0.4173E+00, 0.4654E+00, 0.5200E+00, 0.5820E+00,
     * 0.6525E+00, 0.7328E+00, 0.8244E+00, 0.9291E+00, 0.1049E+01,
     * 0.1186E+01, 0.1344E+01, 0.1526E+01, 0.1736E+01, 0.1977E+01,
     * 0.2257E+01, 0.2580E+01, 0.2956E+01, 0.3392E+01, 0.3901E+01,
     * 0.4494E+01, 0.5188E+01, 0.6001E+01, 0.6955E+01, 0.8078E+01,
     * 0.9399E+01, 0.1095E+02, 0.1276E+02, 0.1486E+02, 0.1727E+02,
     * 0.2006E+02, 0.2372E+02, 0.2698E+02 /
        DATA ((UHR(i,j),j=1,83),i= 2, 2)/
     *-0.3524E+00,-0.3463E+00,-0.3220E+00,-0.2842E+00,-0.2399E+00,
     *-0.1954E+00,-0.1544E+00,-0.1187E+00,-0.8839E-01,-0.6310E-01,
     *-0.4229E-01,-0.2541E-01,-0.1182E-01,-0.9428E-03, 0.7715E-02,
     * 0.1460E-01, 0.2010E-01, 0.2458E-01, 0.2833E-01, 0.3160E-01,
     * 0.3459E-01, 0.3743E-01, 0.4021E-01, 0.4304E-01, 0.4599E-01,
     * 0.4911E-01, 0.5246E-01, 0.5609E-01, 0.6006E-01, 0.6444E-01,
     * 0.6928E-01, 0.7463E-01, 0.8056E-01, 0.8714E-01, 0.9447E-01,
     * 0.1026E+00, 0.1117E+00, 0.1218E+00, 0.1330E+00, 0.1456E+00,
     * 0.1596E+00, 0.1672E+00, 0.1752E+00, 0.1927E+00, 0.2123E+00,
     * 0.2343E+00, 0.2590E+00, 0.2868E+00, 0.3180E+00, 0.3533E+00,
     * 0.3930E+00, 0.4378E+00, 0.4886E+00, 0.5461E+00, 0.6114E+00,
     * 0.6857E+00, 0.7702E+00, 0.8665E+00, 0.9763E+00, 0.1102E+01,
     * 0.1245E+01, 0.1410E+01, 0.1598E+01, 0.1814E+01, 0.2063E+01,
     * 0.2348E+01, 0.2677E+01, 0.3055E+01, 0.3491E+01, 0.3992E+01,
     * 0.4570E+01, 0.5236E+01, 0.6004E+01, 0.6888E+01, 0.7905E+01,
     * 0.9071E+01, 0.1040E+02, 0.1191E+02, 0.1360E+02, 0.1549E+02,
     * 0.1763E+02, 0.2043E+02, 0.2269E+02 /
        DATA ((UHR(i,j),j=1,83),i= 3, 3)/
     *-0.3543E+00,-0.3483E+00,-0.3242E+00,-0.2868E+00,-0.2430E+00,
     *-0.1988E+00,-0.1580E+00,-0.1225E+00,-0.9214E-01,-0.6671E-01,
     *-0.4569E-01,-0.2853E-01,-0.1465E-01,-0.3506E-02, 0.5396E-02,
     * 0.1252E-01, 0.1826E-01, 0.2297E-01, 0.2693E-01, 0.3039E-01,
     * 0.3353E-01, 0.3652E-01, 0.3945E-01, 0.4244E-01, 0.4552E-01,
     * 0.4876E-01, 0.5219E-01, 0.5589E-01, 0.5993E-01, 0.6441E-01,
     * 0.6937E-01, 0.7486E-01, 0.8092E-01, 0.8762E-01, 0.9504E-01,
     * 0.1033E+00, 0.1124E+00, 0.1227E+00, 0.1341E+00, 0.1468E+00,
     * 0.1610E+00, 0.1687E+00, 0.1768E+00, 0.1946E+00, 0.2144E+00,
     * 0.2367E+00, 0.2617E+00, 0.2898E+00, 0.3214E+00, 0.3571E+00,
     * 0.3973E+00, 0.4427E+00, 0.4940E+00, 0.5522E+00, 0.6183E+00,
     * 0.6933E+00, 0.7787E+00, 0.8760E+00, 0.9869E+00, 0.1114E+01,
     * 0.1258E+01, 0.1424E+01, 0.1614E+01, 0.1831E+01, 0.2081E+01,
     * 0.2367E+01, 0.2696E+01, 0.3074E+01, 0.3509E+01, 0.4008E+01,
     * 0.4581E+01, 0.5240E+01, 0.5997E+01, 0.6864E+01, 0.7858E+01,
     * 0.8991E+01, 0.1028E+02, 0.1172E+02, 0.1334E+02, 0.1512E+02,
     * 0.1715E+02, 0.1978E+02, 0.2187E+02 /
        DATA ((UHR(i,j),j=1,83),i= 4, 4)/
     *-0.3623E+00,-0.3563E+00,-0.3319E+00,-0.2945E+00,-0.2511E+00,
     *-0.2074E+00,-0.1670E+00,-0.1316E+00,-0.1013E+00,-0.7564E-01,
     *-0.5424E-01,-0.3660E-01,-0.2215E-01,-0.1035E-01,-0.7512E-03,
     * 0.7037E-02, 0.1339E-01, 0.1864E-01, 0.2309E-01, 0.2701E-01,
     * 0.3060E-01, 0.3398E-01, 0.3728E-01, 0.4060E-01, 0.4399E-01,
     * 0.4752E-01, 0.5126E-01, 0.5525E-01, 0.5956E-01, 0.6429E-01,
     * 0.6950E-01, 0.7522E-01, 0.8152E-01, 0.8848E-01, 0.9621E-01,
     * 0.1048E+00, 0.1143E+00, 0.1249E+00, 0.1367E+00, 0.1498E+00,
     * 0.1645E+00, 0.1725E+00, 0.1809E+00, 0.1991E+00, 0.2196E+00,
     * 0.2426E+00, 0.2684E+00, 0.2974E+00, 0.3300E+00, 0.3668E+00,
     * 0.4082E+00, 0.4549E+00, 0.5077E+00, 0.5675E+00, 0.6353E+00,
     * 0.7124E+00, 0.8000E+00, 0.8996E+00, 0.1013E+01, 0.1142E+01,
     * 0.1290E+01, 0.1458E+01, 0.1650E+01, 0.1870E+01, 0.2122E+01,
     * 0.2410E+01, 0.2740E+01, 0.3116E+01, 0.3547E+01, 0.4039E+01,
     * 0.4600E+01, 0.5240E+01, 0.5969E+01, 0.6796E+01, 0.7733E+01,
     * 0.8788E+01, 0.9970E+01, 0.1128E+02, 0.1272E+02, 0.1429E+02,
     * 0.1607E+02, 0.1836E+02, 0.2008E+02 /
        DATA ((UHR(i,j),j=1,83),i= 5, 5)/
     *-0.3549E+00,-0.3492E+00,-0.3263E+00,-0.2913E+00,-0.2506E+00,
     *-0.2094E+00,-0.1712E+00,-0.1373E+00,-0.1079E+00,-0.8269E-01,
     *-0.6136E-01,-0.4350E-01,-0.2875E-01,-0.1668E-01,-0.6828E-02,
     * 0.1283E-02, 0.8046E-02, 0.1379E-01, 0.1875E-01, 0.2312E-01,
     * 0.2708E-01, 0.3080E-01, 0.3440E-01, 0.3798E-01, 0.4162E-01,
     * 0.4539E-01, 0.4934E-01, 0.5356E-01, 0.5811E-01, 0.6307E-01,
     * 0.6851E-01, 0.7449E-01, 0.8109E-01, 0.8833E-01, 0.9631E-01,
     * 0.1051E+00, 0.1149E+00, 0.1258E+00, 0.1380E+00, 0.1515E+00,
     * 0.1665E+00, 0.1747E+00, 0.1833E+00, 0.2021E+00, 0.2232E+00,
     * 0.2467E+00, 0.2731E+00, 0.3028E+00, 0.3362E+00, 0.3737E+00,
     * 0.4161E+00, 0.4640E+00, 0.5180E+00, 0.5792E+00, 0.6484E+00,
     * 0.7269E+00, 0.8160E+00, 0.9173E+00, 0.1033E+01, 0.1164E+01,
     * 0.1314E+01, 0.1484E+01, 0.1678E+01, 0.1900E+01, 0.2154E+01,
     * 0.2442E+01, 0.2772E+01, 0.3147E+01, 0.3575E+01, 0.4061E+01,
     * 0.4614E+01, 0.5240E+01, 0.5948E+01, 0.6747E+01, 0.7644E+01,
     * 0.8645E+01, 0.9754E+01, 0.1097E+02, 0.1229E+02, 0.1373E+02,
     * 0.1535E+02, 0.1742E+02, 0.1891E+02 /
        DATA ((UHR(i,j),j=1,83),i= 6, 6)/
     *-0.3501E+00,-0.3445E+00,-0.3222E+00,-0.2883E+00,-0.2490E+00,
     *-0.2093E+00,-0.1723E+00,-0.1395E+00,-0.1110E+00,-0.8637E-01,
     *-0.6546E-01,-0.4792E-01,-0.3327E-01,-0.2107E-01,-0.1092E-01,
     *-0.2495E-02, 0.4536E-02, 0.1048E-01, 0.1563E-01, 0.2023E-01,
     * 0.2445E-01, 0.2841E-01, 0.3223E-01, 0.3598E-01, 0.3978E-01,
     * 0.4373E-01, 0.4791E-01, 0.5235E-01, 0.5711E-01, 0.6224E-01,
     * 0.6780E-01, 0.7387E-01, 0.8054E-01, 0.8792E-01, 0.9610E-01,
     * 0.1052E+00, 0.1152E+00, 0.1263E+00, 0.1386E+00, 0.1524E+00,
     * 0.1677E+00, 0.1760E+00, 0.1848E+00, 0.2039E+00, 0.2253E+00,
     * 0.2493E+00, 0.2761E+00, 0.3063E+00, 0.3402E+00, 0.3784E+00,
     * 0.4213E+00, 0.4698E+00, 0.5245E+00, 0.5865E+00, 0.6567E+00,
     * 0.7362E+00, 0.8264E+00, 0.9289E+00, 0.1045E+01, 0.1178E+01,
     * 0.1328E+01, 0.1500E+01, 0.1696E+01, 0.1919E+01, 0.2173E+01,
     * 0.2462E+01, 0.2791E+01, 0.3166E+01, 0.3591E+01, 0.4074E+01,
     * 0.4621E+01, 0.5238E+01, 0.5934E+01, 0.6715E+01, 0.7588E+01,
     * 0.8556E+01, 0.9623E+01, 0.1079E+02, 0.1205E+02, 0.1341E+02,
     * 0.1495E+02, 0.1689E+02, 0.1825E+02 /
        DATA ((UHR(i,j),j=1,83),i= 7, 7)/
     *-0.3444E+00,-0.3391E+00,-0.3180E+00,-0.2860E+00,-0.2488E+00,
     *-0.2111E+00,-0.1758E+00,-0.1442E+00,-0.1165E+00,-0.9248E-01,
     *-0.7187E-01,-0.5442E-01,-0.3969E-01,-0.2726E-01,-0.1682E-01,
     *-0.8060E-02,-0.6755E-03, 0.5616E-02, 0.1109E-01, 0.1600E-01,
     * 0.2054E-01, 0.2481E-01, 0.2894E-01, 0.3302E-01, 0.3715E-01,
     * 0.4138E-01, 0.4580E-01, 0.5046E-01, 0.5543E-01, 0.6080E-01,
     * 0.6664E-01, 0.7299E-01, 0.7993E-01, 0.8757E-01, 0.9601E-01,
     * 0.1053E+00, 0.1157E+00, 0.1271E+00, 0.1398E+00, 0.1539E+00,
     * 0.1697E+00, 0.1782E+00, 0.1872E+00, 0.2068E+00, 0.2287E+00,
     * 0.2532E+00, 0.2807E+00, 0.3116E+00, 0.3463E+00, 0.3853E+00,
     * 0.4292E+00, 0.4786E+00, 0.5344E+00, 0.5976E+00, 0.6690E+00,
     * 0.7500E+00, 0.8417E+00, 0.9457E+00, 0.1064E+01, 0.1198E+01,
     * 0.1350E+01, 0.1523E+01, 0.1720E+01, 0.1944E+01, 0.2199E+01,
     * 0.2488E+01, 0.2817E+01, 0.3189E+01, 0.3611E+01, 0.4087E+01,
     * 0.4624E+01, 0.5228E+01, 0.5905E+01, 0.6660E+01, 0.7497E+01,
     * 0.8420E+01, 0.9427E+01, 0.1052E+02, 0.1169E+02, 0.1294E+02,
     * 0.1436E+02, 0.1613E+02, 0.1732E+02 /
        DATA ((UHR(i,j),j=1,83),i= 8, 8)/
     *-0.3445E+00,-0.3392E+00,-0.3184E+00,-0.2873E+00,-0.2518E+00,
     *-0.2159E+00,-0.1822E+00,-0.1519E+00,-0.1249E+00,-0.1012E+00,
     *-0.8062E-01,-0.6291E-01,-0.4783E-01,-0.3512E-01,-0.2442E-01,
     *-0.1535E-01,-0.7550E-02,-0.7200E-03, 0.5353E-02, 0.1080E-01,
     * 0.1576E-01, 0.2041E-01, 0.2486E-01, 0.2924E-01, 0.3364E-01,
     * 0.3816E-01, 0.4288E-01, 0.4787E-01, 0.5320E-01, 0.5889E-01,
     * 0.6502E-01, 0.7168E-01, 0.7899E-01, 0.8699E-01, 0.9579E-01,
     * 0.1055E+00, 0.1163E+00, 0.1281E+00, 0.1413E+00, 0.1559E+00,
     * 0.1722E+00, 0.1810E+00, 0.1904E+00, 0.2106E+00, 0.2333E+00,
     * 0.2586E+00, 0.2869E+00, 0.3186E+00, 0.3542E+00, 0.3943E+00,
     * 0.4393E+00, 0.4902E+00, 0.5475E+00, 0.6121E+00, 0.6851E+00,
     * 0.7675E+00, 0.8608E+00, 0.9665E+00, 0.1086E+01, 0.1222E+01,
     * 0.1376E+01, 0.1551E+01, 0.1749E+01, 0.1974E+01, 0.2229E+01,
     * 0.2517E+01, 0.2843E+01, 0.3212E+01, 0.3627E+01, 0.4095E+01,
     * 0.4619E+01, 0.5204E+01, 0.5856E+01, 0.6577E+01, 0.7371E+01,
     * 0.8238E+01, 0.9177E+01, 0.1018E+02, 0.1125E+02, 0.1240E+02,
     * 0.1370E+02, 0.1529E+02, 0.1632E+02 /
        DATA ((UHR(i,j),j=1,83),i= 9, 9)/
     *-0.3352E+00,-0.3305E+00,-0.3116E+00,-0.2833E+00,-0.2507E+00,
     *-0.2175E+00,-0.1862E+00,-0.1577E+00,-0.1321E+00,-0.1093E+00,
     *-0.8922E-01,-0.7179E-01,-0.5683E-01,-0.4406E-01,-0.3314E-01,
     *-0.2373E-01,-0.1554E-01,-0.8318E-02,-0.1873E-02, 0.3948E-02,
     * 0.9322E-02, 0.1440E-01, 0.1931E-01, 0.2414E-01, 0.2899E-01,
     * 0.3392E-01, 0.3900E-01, 0.4432E-01, 0.4995E-01, 0.5599E-01,
     * 0.6253E-01, 0.6964E-01, 0.7738E-01, 0.8581E-01, 0.9503E-01,
     * 0.1051E+00, 0.1163E+00, 0.1287E+00, 0.1424E+00, 0.1577E+00,
     * 0.1746E+00, 0.1837E+00, 0.1933E+00, 0.2143E+00, 0.2377E+00,
     * 0.2638E+00, 0.2931E+00, 0.3258E+00, 0.3626E+00, 0.4038E+00,
     * 0.4501E+00, 0.5023E+00, 0.5610E+00, 0.6271E+00, 0.7017E+00,
     * 0.7859E+00, 0.8810E+00, 0.9885E+00, 0.1110E+01, 0.1248E+01,
     * 0.1404E+01, 0.1580E+01, 0.1779E+01, 0.2004E+01, 0.2259E+01,
     * 0.2546E+01, 0.2870E+01, 0.3234E+01, 0.3643E+01, 0.4100E+01,
     * 0.4610E+01, 0.5177E+01, 0.5803E+01, 0.6492E+01, 0.7244E+01,
     * 0.8058E+01, 0.8932E+01, 0.9860E+01, 0.1084E+02, 0.1188E+02,
     * 0.1306E+02, 0.1448E+02, 0.1535E+02 /
        DATA ((UHR(i,j),j=1,83),i=10,10)/
     *-0.3251E+00,-0.3208E+00,-0.3035E+00,-0.2777E+00,-0.2480E+00,
     *-0.2176E+00,-0.1886E+00,-0.1621E+00,-0.1382E+00,-0.1167E+00,
     *-0.9761E-01,-0.8091E-01,-0.6630E-01,-0.5355E-01,-0.4243E-01,
     *-0.3274E-01,-0.2422E-01,-0.1669E-01,-0.9947E-02,-0.3766E-02,
     * 0.2012E-02, 0.7505E-02, 0.1284E-01, 0.1812E-01, 0.2341E-01,
     * 0.2877E-01, 0.3426E-01, 0.3997E-01, 0.4599E-01, 0.5244E-01,
     * 0.5940E-01, 0.6693E-01, 0.7507E-01, 0.8392E-01, 0.9360E-01,
     * 0.1042E+00, 0.1159E+00, 0.1289E+00, 0.1432E+00, 0.1591E+00,
     * 0.1766E+00, 0.1861E+00, 0.1961E+00, 0.2179E+00, 0.2421E+00,
     * 0.2691E+00, 0.2994E+00, 0.3332E+00, 0.3711E+00, 0.4136E+00,
     * 0.4612E+00, 0.5147E+00, 0.5748E+00, 0.6424E+00, 0.7186E+00,
     * 0.8045E+00, 0.9014E+00, 0.1011E+01, 0.1134E+01, 0.1273E+01,
     * 0.1430E+01, 0.1607E+01, 0.1807E+01, 0.2033E+01, 0.2287E+01,
     * 0.2572E+01, 0.2893E+01, 0.3252E+01, 0.3653E+01, 0.4100E+01,
     * 0.4596E+01, 0.5143E+01, 0.5745E+01, 0.6403E+01, 0.7115E+01,
     * 0.7881E+01, 0.8695E+01, 0.9554E+01, 0.1046E+02, 0.1142E+02,
     * 0.1249E+02, 0.1378E+02, 0.1452E+02 /
        DATA ((UHR(i,j),j=1,83),i=11,11)/
     *-0.3184E+00,-0.3143E+00,-0.2983E+00,-0.2743E+00,-0.2467E+00,
     *-0.2186E+00,-0.1917E+00,-0.1669E+00,-0.1442E+00,-0.1236E+00,
     *-0.1050E+00,-0.8855E-01,-0.7408E-01,-0.6144E-01,-0.5037E-01,
     *-0.4060E-01,-0.3190E-01,-0.2406E-01,-0.1693E-01,-0.1038E-01,
     *-0.4264E-02, 0.1565E-02, 0.7208E-02, 0.1278E-01, 0.1836E-01,
     * 0.2402E-01, 0.2983E-01, 0.3589E-01, 0.4227E-01, 0.4906E-01,
     * 0.5635E-01, 0.6423E-01, 0.7277E-01, 0.8204E-01, 0.9214E-01,
     * 0.1032E+00, 0.1153E+00, 0.1287E+00, 0.1436E+00, 0.1600E+00,
     * 0.1782E+00, 0.1880E+00, 0.1983E+00, 0.2207E+00, 0.2457E+00,
     * 0.2735E+00, 0.3046E+00, 0.3393E+00, 0.3781E+00, 0.4216E+00,
     * 0.4703E+00, 0.5250E+00, 0.5864E+00, 0.6552E+00, 0.7327E+00,
     * 0.8199E+00, 0.9180E+00, 0.1028E+01, 0.1153E+01, 0.1293E+01,
     * 0.1451E+01, 0.1629E+01, 0.1829E+01, 0.2054E+01, 0.2307E+01,
     * 0.2590E+01, 0.2908E+01, 0.3262E+01, 0.3656E+01, 0.4094E+01,
     * 0.4578E+01, 0.5109E+01, 0.5691E+01, 0.6323E+01, 0.7004E+01,
     * 0.7732E+01, 0.8503E+01, 0.9312E+01, 0.1016E+02, 0.1106E+02,
     * 0.1207E+02, 0.1326E+02, 0.1392E+02 /
        DATA ((UHR(i,j),j=1,83),i=12,12)/
     *-0.3186E+00,-0.3144E+00,-0.2981E+00,-0.2741E+00,-0.2470E+00,
     *-0.2197E+00,-0.1936E+00,-0.1696E+00,-0.1476E+00,-0.1275E+00,
     *-0.1095E+00,-0.9341E-01,-0.7916E-01,-0.6654E-01,-0.5536E-01,
     *-0.4542E-01,-0.3658E-01,-0.2863E-01,-0.2137E-01,-0.1463E-01,
     *-0.8288E-02,-0.2231E-02, 0.3630E-02, 0.9366E-02, 0.1510E-01,
     * 0.2095E-01, 0.2701E-01, 0.3334E-01, 0.4000E-01, 0.4704E-01,
     * 0.5452E-01, 0.6255E-01, 0.7126E-01, 0.8076E-01, 0.9113E-01,
     * 0.1025E+00, 0.1150E+00, 0.1288E+00, 0.1439E+00, 0.1606E+00,
     * 0.1792E+00, 0.1892E+00, 0.1998E+00, 0.2227E+00, 0.2481E+00,
     * 0.2765E+00, 0.3081E+00, 0.3433E+00, 0.3827E+00, 0.4268E+00,
     * 0.4762E+00, 0.5315E+00, 0.5936E+00, 0.6634E+00, 0.7417E+00,
     * 0.8296E+00, 0.9285E+00, 0.1040E+01, 0.1165E+01, 0.1305E+01,
     * 0.1464E+01, 0.1642E+01, 0.1842E+01, 0.2067E+01, 0.2318E+01,
     * 0.2600E+01, 0.2915E+01, 0.3266E+01, 0.3656E+01, 0.4088E+01,
     * 0.4563E+01, 0.5085E+01, 0.5654E+01, 0.6270E+01, 0.6932E+01,
     * 0.7637E+01, 0.8381E+01, 0.9161E+01, 0.9979E+01, 0.1085E+02,
     * 0.1183E+02, 0.1296E+02, 0.1358E+02 /
        DATA ((UHR(i,j),j=1,83),i=13,13)/
     *-0.3108E+00,-0.3072E+00,-0.2930E+00,-0.2720E+00,-0.2480E+00,
     *-0.2234E+00,-0.2000E+00,-0.1781E+00,-0.1578E+00,-0.1390E+00,
     *-0.1218E+00,-0.1062E+00,-0.9233E-01,-0.7991E-01,-0.6879E-01,
     *-0.5878E-01,-0.4968E-01,-0.4133E-01,-0.3361E-01,-0.2642E-01,
     *-0.1962E-01,-0.1307E-01,-0.6688E-02,-0.3697E-03, 0.5976E-02,
     * 0.1241E-01, 0.1899E-01, 0.2584E-01, 0.3303E-01, 0.4065E-01,
     * 0.4879E-01, 0.5756E-01, 0.6701E-01, 0.7723E-01, 0.8834E-01,
     * 0.1004E+00, 0.1137E+00, 0.1283E+00, 0.1444E+00, 0.1622E+00,
     * 0.1817E+00, 0.1923E+00, 0.2034E+00, 0.2274E+00, 0.2541E+00,
     * 0.2838E+00, 0.3168E+00, 0.3536E+00, 0.3946E+00, 0.4403E+00,
     * 0.4914E+00, 0.5487E+00, 0.6127E+00, 0.6842E+00, 0.7644E+00,
     * 0.8543E+00, 0.9550E+00, 0.1068E+01, 0.1195E+01, 0.1337E+01,
     * 0.1496E+01, 0.1674E+01, 0.1873E+01, 0.2096E+01, 0.2345E+01,
     * 0.2622E+01, 0.2931E+01, 0.3272E+01, 0.3649E+01, 0.4065E+01,
     * 0.4520E+01, 0.5015E+01, 0.5552E+01, 0.6129E+01, 0.6744E+01,
     * 0.7395E+01, 0.8078E+01, 0.8789E+01, 0.9531E+01, 0.1032E+02,
     * 0.1120E+02, 0.1220E+02, 0.1271E+02 /
        DATA ((UHR(i,j),j=1,83),i=14,14)/
     *-0.3172E+00,-0.3136E+00,-0.2996E+00,-0.2795E+00,-0.2570E+00,
     *-0.2344E+00,-0.2128E+00,-0.1927E+00,-0.1739E+00,-0.1563E+00,
     *-0.1401E+00,-0.1252E+00,-0.1117E+00,-0.9936E-01,-0.8813E-01,
     *-0.7783E-01,-0.6833E-01,-0.5951E-01,-0.5130E-01,-0.4354E-01,
     *-0.3608E-01,-0.2884E-01,-0.2171E-01,-0.1462E-01,-0.7470E-02,
     *-0.2342E-03, 0.7158E-02, 0.1482E-01, 0.2285E-01, 0.3135E-01,
     * 0.4045E-01, 0.5020E-01, 0.6063E-01, 0.7189E-01, 0.8408E-01,
     * 0.9732E-01, 0.1118E+00, 0.1277E+00, 0.1452E+00, 0.1643E+00,
     * 0.1854E+00, 0.1968E+00, 0.2087E+00, 0.2344E+00, 0.2629E+00,
     * 0.2945E+00, 0.3295E+00, 0.3684E+00, 0.4116E+00, 0.4596E+00,
     * 0.5131E+00, 0.5728E+00, 0.6391E+00, 0.7130E+00, 0.7955E+00,
     * 0.8877E+00, 0.9905E+00, 0.1105E+01, 0.1233E+01, 0.1376E+01,
     * 0.1535E+01, 0.1712E+01, 0.1909E+01, 0.2128E+01, 0.2371E+01,
     * 0.2640E+01, 0.2938E+01, 0.3264E+01, 0.3623E+01, 0.4014E+01,
     * 0.4439E+01, 0.4898E+01, 0.5391E+01, 0.5916E+01, 0.6471E+01,
     * 0.7054E+01, 0.7660E+01, 0.8289E+01, 0.8945E+01, 0.9644E+01,
     * 0.1042E+02, 0.1126E+02, 0.1165E+02 /
        DATA ((UHR(i,j),j=1,83),i=15,15)/
     *-0.3355E+00,-0.3325E+00,-0.3208E+00,-0.3041E+00,-0.2862E+00,
     *-0.2690E+00,-0.2532E+00,-0.2386E+00,-0.2248E+00,-0.2116E+00,
     *-0.1991E+00,-0.1873E+00,-0.1761E+00,-0.1653E+00,-0.1551E+00,
     *-0.1452E+00,-0.1356E+00,-0.1263E+00,-0.1172E+00,-0.1082E+00,
     *-0.9927E-01,-0.9033E-01,-0.8133E-01,-0.7222E-01,-0.6290E-01,
     *-0.5327E-01,-0.4328E-01,-0.3285E-01,-0.2188E-01,-0.1031E-01,
     * 0.1921E-02, 0.1493E-01, 0.2884E-01, 0.4377E-01, 0.5984E-01,
     * 0.7724E-01, 0.9610E-01, 0.1165E+00, 0.1386E+00, 0.1627E+00,
     * 0.1890E+00, 0.2030E+00, 0.2177E+00, 0.2491E+00, 0.2835E+00,
     * 0.3211E+00, 0.3623E+00, 0.4076E+00, 0.4572E+00, 0.5118E+00,
     * 0.5717E+00, 0.6376E+00, 0.7102E+00, 0.7899E+00, 0.8775E+00,
     * 0.9738E+00, 0.1080E+01, 0.1196E+01, 0.1324E+01, 0.1464E+01,
     * 0.1618E+01, 0.1786E+01, 0.1971E+01, 0.2172E+01, 0.2391E+01,
     * 0.2629E+01, 0.2887E+01, 0.3165E+01, 0.3465E+01, 0.3787E+01,
     * 0.4129E+01, 0.4493E+01, 0.4876E+01, 0.5278E+01, 0.5699E+01,
     * 0.6137E+01, 0.6593E+01, 0.7071E+01, 0.7579E+01, 0.8125E+01,
     * 0.8710E+01, 0.9260E+01, 0.9472E+01 /
        DATA ((UHR(i,j),j=1,83),i=16,16)/
     *-0.2986E+00,-0.2969E+00,-0.2903E+00,-0.2811E+00,-0.2717E+00,
     *-0.2631E+00,-0.2554E+00,-0.2484E+00,-0.2417E+00,-0.2351E+00,
     *-0.2286E+00,-0.2220E+00,-0.2154E+00,-0.2086E+00,-0.2016E+00,
     *-0.1945E+00,-0.1874E+00,-0.1801E+00,-0.1726E+00,-0.1650E+00,
     *-0.1572E+00,-0.1491E+00,-0.1408E+00,-0.1322E+00,-0.1231E+00,
     *-0.1137E+00,-0.1038E+00,-0.9336E-01,-0.8228E-01,-0.7050E-01,
     *-0.5794E-01,-0.4453E-01,-0.3018E-01,-0.1472E-01, 0.1974E-02,
     * 0.1998E-01, 0.3942E-01, 0.6046E-01, 0.8329E-01, 0.1081E+00,
     * 0.1351E+00, 0.1495E+00, 0.1645E+00, 0.1965E+00, 0.2314E+00,
     * 0.2696E+00, 0.3113E+00, 0.3569E+00, 0.4069E+00, 0.4615E+00,
     * 0.5214E+00, 0.5872E+00, 0.6594E+00, 0.7386E+00, 0.8256E+00,
     * 0.9211E+00, 0.1026E+01, 0.1141E+01, 0.1268E+01, 0.1407E+01,
     * 0.1561E+01, 0.1729E+01, 0.1913E+01, 0.2115E+01, 0.2337E+01,
     * 0.2580E+01, 0.2845E+01, 0.3134E+01, 0.3449E+01, 0.3791E+01,
     * 0.4161E+01, 0.4561E+01, 0.4991E+01, 0.5453E+01, 0.5949E+01,
     * 0.6480E+01, 0.7049E+01, 0.7661E+01, 0.8324E+01, 0.9038E+01,
     * 0.9780E+01, 0.1043E+02, 0.1066E+02 /
        DATA ((UHR(i,j),j=1,83),i=17,17)/
     *-0.3040E+00,-0.3026E+00,-0.2970E+00,-0.2890E+00,-0.2804E+00,
     *-0.2723E+00,-0.2650E+00,-0.2584E+00,-0.2524E+00,-0.2467E+00,
     *-0.2410E+00,-0.2351E+00,-0.2291E+00,-0.2229E+00,-0.2165E+00,
     *-0.2098E+00,-0.2029E+00,-0.1959E+00,-0.1887E+00,-0.1813E+00,
     *-0.1736E+00,-0.1656E+00,-0.1573E+00,-0.1486E+00,-0.1396E+00,
     *-0.1300E+00,-0.1199E+00,-0.1093E+00,-0.9800E-01,-0.8599E-01,
     *-0.7316E-01,-0.5941E-01,-0.4468E-01,-0.2888E-01,-0.1189E-01,
     * 0.6459E-02, 0.2630E-01, 0.4776E-01, 0.7101E-01, 0.9619E-01,
     * 0.1235E+00, 0.1381E+00, 0.1532E+00, 0.1856E+00, 0.2209E+00,
     * 0.2593E+00, 0.3012E+00, 0.3470E+00, 0.3969E+00, 0.4516E+00,
     * 0.5115E+00, 0.5770E+00, 0.6487E+00, 0.7273E+00, 0.8135E+00,
     * 0.9082E+00, 0.1012E+01, 0.1126E+01, 0.1251E+01, 0.1388E+01,
     * 0.1539E+01, 0.1705E+01, 0.1887E+01, 0.2086E+01, 0.2305E+01,
     * 0.2545E+01, 0.2808E+01, 0.3096E+01, 0.3411E+01, 0.3754E+01,
     * 0.4127E+01, 0.4534E+01, 0.4975E+01, 0.5452E+01, 0.5968E+01,
     * 0.6526E+01, 0.7131E+01, 0.7787E+01, 0.8497E+01, 0.9256E+01,
     * 0.1003E+02, 0.1069E+02, 0.1091E+02 /
        DATA ((UHR(i,j),j=1,83),i=18,18)/
     *-0.3020E+00,-0.3010E+00,-0.2972E+00,-0.2919E+00,-0.2865E+00,
     *-0.2817E+00,-0.2774E+00,-0.2735E+00,-0.2698E+00,-0.2660E+00,
     *-0.2621E+00,-0.2579E+00,-0.2534E+00,-0.2488E+00,-0.2438E+00,
     *-0.2386E+00,-0.2331E+00,-0.2273E+00,-0.2212E+00,-0.2148E+00,
     *-0.2081E+00,-0.2010E+00,-0.1934E+00,-0.1855E+00,-0.1770E+00,
     *-0.1681E+00,-0.1586E+00,-0.1484E+00,-0.1376E+00,-0.1260E+00,
     *-0.1137E+00,-0.1004E+00,-0.8612E-01,-0.7079E-01,-0.5430E-01,
     *-0.3653E-01,-0.1736E-01, 0.3350E-02, 0.2573E-01, 0.4993E-01,
     * 0.7616E-01, 0.9008E-01, 0.1046E+00, 0.1354E+00, 0.1689E+00,
     * 0.2052E+00, 0.2448E+00, 0.2878E+00, 0.3347E+00, 0.3858E+00,
     * 0.4416E+00, 0.5025E+00, 0.5690E+00, 0.6418E+00, 0.7216E+00,
     * 0.8090E+00, 0.9050E+00, 0.1010E+01, 0.1127E+01, 0.1255E+01,
     * 0.1396E+01, 0.1552E+01, 0.1725E+01, 0.1918E+01, 0.2132E+01,
     * 0.2371E+01, 0.2639E+01, 0.2939E+01, 0.3277E+01, 0.3659E+01,
     * 0.4091E+01, 0.4582E+01, 0.5141E+01, 0.5776E+01, 0.6499E+01,
     * 0.7321E+01, 0.8249E+01, 0.9290E+01, 0.1044E+02, 0.1166E+02,
     * 0.1286E+02, 0.1383E+02, 0.1415E+02 /
        DATA ((UHR(i,j),j=1,83),i=19,19)/
     *-0.3020E+00,-0.3015E+00,-0.2993E+00,-0.2963E+00,-0.2934E+00,
     *-0.2907E+00,-0.2882E+00,-0.2857E+00,-0.2830E+00,-0.2802E+00,
     *-0.2770E+00,-0.2736E+00,-0.2699E+00,-0.2659E+00,-0.2616E+00,
     *-0.2570E+00,-0.2520E+00,-0.2466E+00,-0.2409E+00,-0.2349E+00,
     *-0.2284E+00,-0.2216E+00,-0.2143E+00,-0.2066E+00,-0.1983E+00,
     *-0.1896E+00,-0.1802E+00,-0.1702E+00,-0.1596E+00,-0.1482E+00,
     *-0.1360E+00,-0.1229E+00,-0.1089E+00,-0.9387E-01,-0.7772E-01,
     *-0.6037E-01,-0.4170E-01,-0.2161E-01, 0.3854E-04, 0.2337E-01,
     * 0.4855E-01, 0.6188E-01, 0.7573E-01, 0.1051E+00, 0.1368E+00,
     * 0.1712E+00, 0.2084E+00, 0.2487E+00, 0.2924E+00, 0.3399E+00,
     * 0.3915E+00, 0.4477E+00, 0.5089E+00, 0.5756E+00, 0.6486E+00,
     * 0.7285E+00, 0.8160E+00, 0.9123E+00, 0.1018E+01, 0.1135E+01,
     * 0.1265E+01, 0.1409E+01, 0.1570E+01, 0.1751E+01, 0.1954E+01,
     * 0.2185E+01, 0.2447E+01, 0.2749E+01, 0.3097E+01, 0.3501E+01,
     * 0.3975E+01, 0.4533E+01, 0.5195E+01, 0.5981E+01, 0.6917E+01,
     * 0.8026E+01, 0.9330E+01, 0.1084E+02, 0.1253E+02, 0.1434E+02,
     * 0.1609E+02, 0.1744E+02, 0.1785E+02 /
        DATA ((UHR(i,j),j=1,83),i=20,20)/
     *-0.3991E+00,-0.3988E+00,-0.3975E+00,-0.3952E+00,-0.3922E+00,
     *-0.3886E+00,-0.3846E+00,-0.3804E+00,-0.3758E+00,-0.3710E+00,
     *-0.3658E+00,-0.3604E+00,-0.3545E+00,-0.3484E+00,-0.3418E+00,
     *-0.3349E+00,-0.3275E+00,-0.3197E+00,-0.3115E+00,-0.3028E+00,
     *-0.2937E+00,-0.2840E+00,-0.2737E+00,-0.2629E+00,-0.2515E+00,
     *-0.2395E+00,-0.2268E+00,-0.2133E+00,-0.1991E+00,-0.1841E+00,
     *-0.1682E+00,-0.1513E+00,-0.1335E+00,-0.1146E+00,-0.9463E-01,
     *-0.7341E-01,-0.5089E-01,-0.2699E-01,-0.1594E-02, 0.2540E-01,
     * 0.5413E-01, 0.6918E-01, 0.8472E-01, 0.1173E+00, 0.1521E+00,
     * 0.1893E+00, 0.2290E+00, 0.2716E+00, 0.3172E+00, 0.3663E+00,
     * 0.4191E+00, 0.4760E+00, 0.5375E+00, 0.6042E+00, 0.6765E+00,
     * 0.7554E+00, 0.8415E+00, 0.9359E+00, 0.1040E+01, 0.1154E+01,
     * 0.1281E+01, 0.1423E+01, 0.1581E+01, 0.1758E+01, 0.1958E+01,
     * 0.2185E+01, 0.2443E+01, 0.2737E+01, 0.3073E+01, 0.3459E+01,
     * 0.3903E+01, 0.4412E+01, 0.4996E+01, 0.5663E+01, 0.6418E+01,
     * 0.7263E+01, 0.8190E+01, 0.9182E+01, 0.1020E+02, 0.1118E+02,
     * 0.1203E+02, 0.1261E+02, 0.1277E+02 /


      do 1 i=1,20
       asy(1,i)=asy_m(i)
       ex(1,i)=ex_m(i)
       sc(1,i)=sc_m(i)
      do 1 j=1,nquad
       ph(i,j)=phr(i,j)
       qh(i,j)=qhr(i,j)
       uh(i,j)=uhr(i,j)
    1 continue    
      return
      end
