       subroutine   wate

c - to vary the number of quadratures
      include "paramdef.inc"
      integer nquad
      common /num_quad/ nquad
      real ph,qh,uh
      common /sixs_aerbas/ ph(20,nqmax_p),qh(20,nqmax_p),uh(20,nqmax_p)
      real phr(20,nqdef_p),qhr(20,nqdef_p),uhr(20,nqdef_p)
c - to vary the number of quadratures
      real ex,sc,asy,vi
      common /sixs_coef/ ex(4,20),sc(4,20),asy(4,20),vi(4)
      real ex_m(20),sc_m(20),asy_m(20),vi_m
      integer i,j

c Water-soluble model
c Parameters and refractive indices - G.A. d'Almeida, 'Atmospheric
c aerosols. Global climatology and radiative characteristics', 1991.
c Extinction coefficients are calculated in km-1

c*************** MIE (asy) ******************
      data (asy_m(j),j=1,20)/
     a 0.663,0.657,0.655,0.651,0.648,0.645,0.642,0.638,0.633,0.628,
     a 0.623,0.620,0.613,0.605,0.563,0.549,0.535,0.493,0.469,0.369/
c*************** MIE (ext&sca) ******************
        data (ex_m(j),sc_m(j),j=1,20) /
     a 0.1668202E-01,0.1611682E-01,0.1485427E-01,0.1436933E-01,
     a 0.1444705E-01,0.1397780E-01,0.1344278E-01,0.1301239E-01,
     a 0.1263220E-01,0.1223016E-01,0.1211881E-01,0.1173550E-01,
     a 0.1139759E-01,0.1101810E-01,0.1053951E-01,0.1014493E-01,
     a 0.9646374E-02,0.9284852E-02,0.8791811E-02,0.8424427E-02,
     a 0.8128974E-02,0.7772448E-02,0.7729647E-02,0.7389077E-02,
     a 0.6740132E-02,0.6363583E-02,0.5455605E-02,0.5064777E-02,
     a 0.2838330E-02,0.2432695E-02,0.1442047E-02,0.1098548E-02,
     a 0.1220081E-02,0.9381454E-03,0.1323107E-02,0.5656477E-03,
     a 0.8564052E-03,0.4127454E-03,0.1457627E-03,0.1244750E-03 /
c************** MIE (phase fun ph) ***************
        DATA ((PHR(i,j),j=1,83),i= 1, 1)/
     *0.4078E+00,0.4008E+00,0.3754E+00,0.3409E+00,0.3069E+00,
     *0.2790E+00,0.2597E+00,0.2483E+00,0.2419E+00,0.2373E+00,
     *0.2327E+00,0.2270E+00,0.2204E+00,0.2128E+00,0.2049E+00,
     *0.1969E+00,0.1894E+00,0.1825E+00,0.1763E+00,0.1710E+00,
     *0.1664E+00,0.1627E+00,0.1598E+00,0.1576E+00,0.1561E+00,
     *0.1555E+00,0.1556E+00,0.1565E+00,0.1583E+00,0.1608E+00,
     *0.1641E+00,0.1683E+00,0.1734E+00,0.1794E+00,0.1864E+00,
     *0.1945E+00,0.2038E+00,0.2145E+00,0.2265E+00,0.2400E+00,
     *0.2553E+00,0.2636E+00,0.2725E+00,0.2919E+00,0.3137E+00,
     *0.3380E+00,0.3653E+00,0.3959E+00,0.4304E+00,0.4693E+00,
     *0.5130E+00,0.5620E+00,0.6170E+00,0.6790E+00,0.7492E+00,
     *0.8284E+00,0.9179E+00,0.1019E+01,0.1134E+01,0.1263E+01,
     *0.1410E+01,0.1576E+01,0.1765E+01,0.1979E+01,0.2222E+01,
     *0.2498E+01,0.2811E+01,0.3167E+01,0.3571E+01,0.4028E+01,
     *0.4548E+01,0.5137E+01,0.5806E+01,0.6564E+01,0.7422E+01,
     *0.8393E+01,0.9490E+01,0.1072E+02,0.1209E+02,0.1358E+02,
     *0.1508E+02,0.1632E+02,0.1673E+02 /
        DATA ((PHR(i,j),j=1,83),i= 2, 2)/
     *0.3768E+00,0.3712E+00,0.3505E+00,0.3219E+00,0.2929E+00,
     *0.2686E+00,0.2513E+00,0.2406E+00,0.2345E+00,0.2303E+00,
     *0.2263E+00,0.2215E+00,0.2157E+00,0.2093E+00,0.2026E+00,
     *0.1958E+00,0.1893E+00,0.1833E+00,0.1779E+00,0.1731E+00,
     *0.1690E+00,0.1657E+00,0.1631E+00,0.1613E+00,0.1601E+00,
     *0.1598E+00,0.1602E+00,0.1614E+00,0.1633E+00,0.1660E+00,
     *0.1694E+00,0.1738E+00,0.1790E+00,0.1853E+00,0.1926E+00,
     *0.2009E+00,0.2105E+00,0.2214E+00,0.2338E+00,0.2479E+00,
     *0.2638E+00,0.2724E+00,0.2816E+00,0.3015E+00,0.3239E+00,
     *0.3490E+00,0.3773E+00,0.4091E+00,0.4448E+00,0.4848E+00,
     *0.5297E+00,0.5803E+00,0.6371E+00,0.7011E+00,0.7732E+00,
     *0.8544E+00,0.9461E+00,0.1050E+01,0.1167E+01,0.1299E+01,
     *0.1448E+01,0.1617E+01,0.1808E+01,0.2024E+01,0.2268E+01,
     *0.2544E+01,0.2856E+01,0.3209E+01,0.3607E+01,0.4055E+01,
     *0.4560E+01,0.5128E+01,0.5766E+01,0.6481E+01,0.7279E+01,
     *0.8169E+01,0.9154E+01,0.1023E+02,0.1140E+02,0.1262E+02,
     *0.1380E+02,0.1472E+02,0.1501E+02 /
        DATA ((PHR(i,j),j=1,83),i= 3, 3)/
     *0.3723E+00,0.3669E+00,0.3467E+00,0.3189E+00,0.2907E+00,
     *0.2671E+00,0.2502E+00,0.2396E+00,0.2335E+00,0.2294E+00,
     *0.2254E+00,0.2207E+00,0.2151E+00,0.2088E+00,0.2023E+00,
     *0.1958E+00,0.1895E+00,0.1836E+00,0.1783E+00,0.1736E+00,
     *0.1696E+00,0.1664E+00,0.1639E+00,0.1622E+00,0.1612E+00,
     *0.1609E+00,0.1613E+00,0.1625E+00,0.1645E+00,0.1672E+00,
     *0.1707E+00,0.1751E+00,0.1804E+00,0.1867E+00,0.1941E+00,
     *0.2026E+00,0.2122E+00,0.2232E+00,0.2357E+00,0.2499E+00,
     *0.2659E+00,0.2746E+00,0.2838E+00,0.3038E+00,0.3264E+00,
     *0.3518E+00,0.3803E+00,0.4124E+00,0.4482E+00,0.4885E+00,
     *0.5337E+00,0.5845E+00,0.6418E+00,0.7063E+00,0.7788E+00,
     *0.8605E+00,0.9525E+00,0.1056E+01,0.1174E+01,0.1307E+01,
     *0.1456E+01,0.1626E+01,0.1817E+01,0.2033E+01,0.2277E+01,
     *0.2553E+01,0.2865E+01,0.3216E+01,0.3612E+01,0.4058E+01,
     *0.4560E+01,0.5123E+01,0.5753E+01,0.6458E+01,0.7244E+01,
     *0.8115E+01,0.9076E+01,0.1013E+02,0.1125E+02,0.1242E+02,
     *0.1355E+02,0.1442E+02,0.1469E+02 /
        DATA ((PHR(i,j),j=1,83),i= 4, 4)/
     *0.3587E+00,0.3539E+00,0.3359E+00,0.3107E+00,0.2848E+00,
     *0.2629E+00,0.2469E+00,0.2368E+00,0.2308E+00,0.2267E+00,
     *0.2229E+00,0.2186E+00,0.2135E+00,0.2078E+00,0.2019E+00,
     *0.1958E+00,0.1900E+00,0.1846E+00,0.1797E+00,0.1754E+00,
     *0.1717E+00,0.1687E+00,0.1663E+00,0.1647E+00,0.1638E+00,
     *0.1636E+00,0.1642E+00,0.1655E+00,0.1676E+00,0.1704E+00,
     *0.1740E+00,0.1785E+00,0.1839E+00,0.1904E+00,0.1979E+00,
     *0.2065E+00,0.2163E+00,0.2276E+00,0.2403E+00,0.2548E+00,
     *0.2711E+00,0.2800E+00,0.2894E+00,0.3098E+00,0.3328E+00,
     *0.3586E+00,0.3877E+00,0.4203E+00,0.4568E+00,0.4978E+00,
     *0.5438E+00,0.5955E+00,0.6537E+00,0.7190E+00,0.7925E+00,
     *0.8753E+00,0.9685E+00,0.1074E+01,0.1192E+01,0.1326E+01,
     *0.1477E+01,0.1647E+01,0.1839E+01,0.2055E+01,0.2299E+01,
     *0.2575E+01,0.2885E+01,0.3233E+01,0.3625E+01,0.4065E+01,
     *0.4557E+01,0.5107E+01,0.5720E+01,0.6401E+01,0.7154E+01,
     *0.7982E+01,0.8887E+01,0.9863E+01,0.1090E+02,0.1195E+02,
     *0.1293E+02,0.1368E+02,0.1390E+02 /
        DATA ((PHR(i,j),j=1,83),i= 5, 5)/
     *0.3523E+00,0.3477E+00,0.3304E+00,0.3062E+00,0.2815E+00,
     *0.2607E+00,0.2455E+00,0.2356E+00,0.2296E+00,0.2256E+00,
     *0.2219E+00,0.2177E+00,0.2129E+00,0.2076E+00,0.2020E+00,
     *0.1963E+00,0.1909E+00,0.1857E+00,0.1810E+00,0.1769E+00,
     *0.1734E+00,0.1705E+00,0.1684E+00,0.1669E+00,0.1662E+00,
     *0.1662E+00,0.1668E+00,0.1681E+00,0.1703E+00,0.1732E+00,
     *0.1769E+00,0.1816E+00,0.1871E+00,0.1937E+00,0.2013E+00,
     *0.2101E+00,0.2202E+00,0.2316E+00,0.2446E+00,0.2592E+00,
     *0.2757E+00,0.2847E+00,0.2942E+00,0.3151E+00,0.3385E+00,
     *0.3648E+00,0.3943E+00,0.4273E+00,0.4643E+00,0.5058E+00,
     *0.5524E+00,0.6048E+00,0.6637E+00,0.7298E+00,0.8042E+00,
     *0.8878E+00,0.9818E+00,0.1088E+01,0.1207E+01,0.1341E+01,
     *0.1493E+01,0.1663E+01,0.1856E+01,0.2072E+01,0.2316E+01,
     *0.2590E+01,0.2898E+01,0.3244E+01,0.3631E+01,0.4065E+01,
     *0.4549E+01,0.5088E+01,0.5686E+01,0.6347E+01,0.7074E+01,
     *0.7868E+01,0.8728E+01,0.9649E+01,0.1061E+02,0.1159E+02,
     *0.1249E+02,0.1316E+02,0.1335E+02 /
        DATA ((PHR(i,j),j=1,83),i= 6, 6)/
     *0.3444E+00,0.3402E+00,0.3244E+00,0.3021E+00,0.2789E+00,
     *0.2590E+00,0.2442E+00,0.2346E+00,0.2286E+00,0.2245E+00,
     *0.2209E+00,0.2170E+00,0.2125E+00,0.2075E+00,0.2021E+00,
     *0.1967E+00,0.1914E+00,0.1865E+00,0.1821E+00,0.1781E+00,
     *0.1748E+00,0.1721E+00,0.1700E+00,0.1686E+00,0.1678E+00,
     *0.1678E+00,0.1685E+00,0.1699E+00,0.1721E+00,0.1750E+00,
     *0.1788E+00,0.1835E+00,0.1891E+00,0.1957E+00,0.2034E+00,
     *0.2123E+00,0.2224E+00,0.2340E+00,0.2471E+00,0.2619E+00,
     *0.2786E+00,0.2877E+00,0.2974E+00,0.3185E+00,0.3421E+00,
     *0.3686E+00,0.3983E+00,0.4317E+00,0.4691E+00,0.5111E+00,
     *0.5582E+00,0.6110E+00,0.6702E+00,0.7367E+00,0.8115E+00,
     *0.8956E+00,0.9903E+00,0.1097E+01,0.1217E+01,0.1352E+01,
     *0.1503E+01,0.1674E+01,0.1867E+01,0.2083E+01,0.2326E+01,
     *0.2600E+01,0.2907E+01,0.3251E+01,0.3636E+01,0.4065E+01,
     *0.4544E+01,0.5076E+01,0.5664E+01,0.6313E+01,0.7023E+01,
     *0.7797E+01,0.8630E+01,0.9516E+01,0.1043E+02,0.1135E+02,
     *0.1219E+02,0.1280E+02,0.1298E+02 /
        DATA ((PHR(i,j),j=1,83),i= 7, 7)/
     *0.3349E+00,0.3311E+00,0.3167E+00,0.2962E+00,0.2748E+00,
     *0.2562E+00,0.2422E+00,0.2329E+00,0.2272E+00,0.2232E+00,
     *0.2197E+00,0.2160E+00,0.2118E+00,0.2071E+00,0.2021E+00,
     *0.1970E+00,0.1921E+00,0.1875E+00,0.1833E+00,0.1796E+00,
     *0.1765E+00,0.1739E+00,0.1720E+00,0.1707E+00,0.1701E+00,
     *0.1701E+00,0.1709E+00,0.1725E+00,0.1747E+00,0.1778E+00,
     *0.1816E+00,0.1864E+00,0.1921E+00,0.1989E+00,0.2067E+00,
     *0.2157E+00,0.2260E+00,0.2377E+00,0.2510E+00,0.2661E+00,
     *0.2830E+00,0.2923E+00,0.3020E+00,0.3234E+00,0.3473E+00,
     *0.3742E+00,0.4044E+00,0.4382E+00,0.4761E+00,0.5186E+00,
     *0.5662E+00,0.6196E+00,0.6795E+00,0.7468E+00,0.8223E+00,
     *0.9071E+00,0.1002E+01,0.1110E+01,0.1230E+01,0.1366E+01,
     *0.1518E+01,0.1689E+01,0.1882E+01,0.2098E+01,0.2340E+01,
     *0.2613E+01,0.2918E+01,0.3259E+01,0.3639E+01,0.4063E+01,
     *0.4534E+01,0.5055E+01,0.5630E+01,0.6261E+01,0.6949E+01,
     *0.7693E+01,0.8490E+01,0.9330E+01,0.1019E+02,0.1104E+02,
     *0.1181E+02,0.1236E+02,0.1251E+02 /
        DATA ((PHR(i,j),j=1,83),i= 8, 8)/
     *0.3249E+00,0.3214E+00,0.3083E+00,0.2894E+00,0.2697E+00,
     *0.2525E+00,0.2395E+00,0.2309E+00,0.2253E+00,0.2214E+00,
     *0.2181E+00,0.2147E+00,0.2108E+00,0.2066E+00,0.2021E+00,
     *0.1974E+00,0.1929E+00,0.1887E+00,0.1848E+00,0.1814E+00,
     *0.1785E+00,0.1762E+00,0.1745E+00,0.1734E+00,0.1729E+00,
     *0.1731E+00,0.1740E+00,0.1756E+00,0.1780E+00,0.1811E+00,
     *0.1852E+00,0.1901E+00,0.1960E+00,0.2028E+00,0.2108E+00,
     *0.2200E+00,0.2306E+00,0.2425E+00,0.2561E+00,0.2714E+00,
     *0.2886E+00,0.2980E+00,0.3079E+00,0.3297E+00,0.3542E+00,
     *0.3816E+00,0.4122E+00,0.4465E+00,0.4850E+00,0.5281E+00,
     *0.5764E+00,0.6305E+00,0.6912E+00,0.7593E+00,0.8356E+00,
     *0.9213E+00,0.1017E+01,0.1125E+01,0.1246E+01,0.1382E+01,
     *0.1535E+01,0.1707E+01,0.1899E+01,0.2115E+01,0.2356E+01,
     *0.2626E+01,0.2928E+01,0.3266E+01,0.3641E+01,0.4057E+01,
     *0.4518E+01,0.5027E+01,0.5585E+01,0.6194E+01,0.6855E+01,
     *0.7565E+01,0.8319E+01,0.9107E+01,0.9909E+01,0.1069E+02,
     *0.1138E+02,0.1187E+02,0.1200E+02 /
        DATA ((PHR(i,j),j=1,83),i= 9, 9)/
     *0.3184E+00,0.3153E+00,0.3034E+00,0.2863E+00,0.2683E+00,
     *0.2524E+00,0.2402E+00,0.2319E+00,0.2264E+00,0.2225E+00,
     *0.2193E+00,0.2159E+00,0.2122E+00,0.2082E+00,0.2039E+00,
     *0.1996E+00,0.1954E+00,0.1914E+00,0.1878E+00,0.1846E+00,
     *0.1819E+00,0.1797E+00,0.1781E+00,0.1771E+00,0.1768E+00,
     *0.1771E+00,0.1781E+00,0.1798E+00,0.1823E+00,0.1855E+00,
     *0.1896E+00,0.1946E+00,0.2006E+00,0.2076E+00,0.2158E+00,
     *0.2252E+00,0.2359E+00,0.2481E+00,0.2619E+00,0.2775E+00,
     *0.2951E+00,0.3046E+00,0.3148E+00,0.3370E+00,0.3618E+00,
     *0.3897E+00,0.4209E+00,0.4559E+00,0.4950E+00,0.5387E+00,
     *0.5877E+00,0.6426E+00,0.7042E+00,0.7731E+00,0.8503E+00,
     *0.9367E+00,0.1034E+01,0.1142E+01,0.1264E+01,0.1400E+01,
     *0.1553E+01,0.1725E+01,0.1917E+01,0.2131E+01,0.2371E+01,
     *0.2639E+01,0.2938E+01,0.3270E+01,0.3638E+01,0.4046E+01,
     *0.4495E+01,0.4989E+01,0.5528E+01,0.6114E+01,0.6745E+01,
     *0.7418E+01,0.8128E+01,0.8861E+01,0.9600E+01,0.1031E+02,
     *0.1093E+02,0.1135E+02,0.1147E+02 /
        DATA ((PHR(i,j),j=1,83),i=10,10)/
     *0.3086E+00,0.3060E+00,0.2958E+00,0.2810E+00,0.2650E+00,
     *0.2507E+00,0.2395E+00,0.2316E+00,0.2263E+00,0.2226E+00,
     *0.2194E+00,0.2163E+00,0.2129E+00,0.2092E+00,0.2053E+00,
     *0.2014E+00,0.1975E+00,0.1939E+00,0.1906E+00,0.1876E+00,
     *0.1851E+00,0.1831E+00,0.1817E+00,0.1809E+00,0.1807E+00,
     *0.1811E+00,0.1822E+00,0.1840E+00,0.1866E+00,0.1899E+00,
     *0.1941E+00,0.1993E+00,0.2054E+00,0.2125E+00,0.2209E+00,
     *0.2304E+00,0.2414E+00,0.2538E+00,0.2679E+00,0.2838E+00,
     *0.3017E+00,0.3115E+00,0.3219E+00,0.3444E+00,0.3697E+00,
     *0.3981E+00,0.4299E+00,0.4654E+00,0.5052E+00,0.5497E+00,
     *0.5994E+00,0.6551E+00,0.7173E+00,0.7870E+00,0.8650E+00,
     *0.9522E+00,0.1050E+01,0.1159E+01,0.1281E+01,0.1418E+01,
     *0.1571E+01,0.1743E+01,0.1934E+01,0.2147E+01,0.2385E+01,
     *0.2650E+01,0.2945E+01,0.3272E+01,0.3633E+01,0.4032E+01,
     *0.4470E+01,0.4949E+01,0.5470E+01,0.6033E+01,0.6636E+01,
     *0.7275E+01,0.7942E+01,0.8626E+01,0.9306E+01,0.9948E+01,
     *0.1050E+02,0.1087E+02,0.1097E+02 /
        DATA ((PHR(i,j),j=1,83),i=11,11)/
     *0.3051E+00,0.3027E+00,0.2933E+00,0.2795E+00,0.2646E+00,
     *0.2512E+00,0.2406E+00,0.2330E+00,0.2279E+00,0.2241E+00,
     *0.2210E+00,0.2179E+00,0.2147E+00,0.2111E+00,0.2075E+00,
     *0.2038E+00,0.2001E+00,0.1966E+00,0.1935E+00,0.1907E+00,
     *0.1883E+00,0.1865E+00,0.1851E+00,0.1844E+00,0.1843E+00,
     *0.1848E+00,0.1859E+00,0.1878E+00,0.1904E+00,0.1939E+00,
     *0.1982E+00,0.2034E+00,0.2096E+00,0.2169E+00,0.2254E+00,
     *0.2351E+00,0.2462E+00,0.2589E+00,0.2732E+00,0.2893E+00,
     *0.3075E+00,0.3174E+00,0.3279E+00,0.3508E+00,0.3766E+00,
     *0.4053E+00,0.4375E+00,0.4736E+00,0.5138E+00,0.5588E+00,
     *0.6091E+00,0.6653E+00,0.7282E+00,0.7985E+00,0.8771E+00,
     *0.9649E+00,0.1063E+01,0.1173E+01,0.1295E+01,0.1432E+01,
     *0.1585E+01,0.1756E+01,0.1947E+01,0.2159E+01,0.2395E+01,
     *0.2658E+01,0.2949E+01,0.3271E+01,0.3626E+01,0.4017E+01,
     *0.4445E+01,0.4912E+01,0.5418E+01,0.5962E+01,0.6542E+01,
     *0.7153E+01,0.7788E+01,0.8434E+01,0.9071E+01,0.9668E+01,
     *0.1017E+02,0.1051E+02,0.1060E+02 /
        DATA ((PHR(i,j),j=1,83),i=12,12)/
     *0.3033E+00,0.3011E+00,0.2923E+00,0.2793E+00,0.2651E+00,
     *0.2523E+00,0.2420E+00,0.2346E+00,0.2294E+00,0.2256E+00,
     *0.2225E+00,0.2194E+00,0.2163E+00,0.2128E+00,0.2093E+00,
     *0.2056E+00,0.2021E+00,0.1987E+00,0.1956E+00,0.1929E+00,
     *0.1907E+00,0.1889E+00,0.1876E+00,0.1869E+00,0.1867E+00,
     *0.1873E+00,0.1884E+00,0.1903E+00,0.1930E+00,0.1965E+00,
     *0.2008E+00,0.2061E+00,0.2124E+00,0.2197E+00,0.2283E+00,
     *0.2381E+00,0.2493E+00,0.2621E+00,0.2765E+00,0.2928E+00,
     *0.3112E+00,0.3212E+00,0.3318E+00,0.3550E+00,0.3809E+00,
     *0.4099E+00,0.4424E+00,0.4787E+00,0.5193E+00,0.5646E+00,
     *0.6153E+00,0.6719E+00,0.7351E+00,0.8057E+00,0.8845E+00,
     *0.9727E+00,0.1071E+01,0.1181E+01,0.1304E+01,0.1441E+01,
     *0.1594E+01,0.1764E+01,0.1954E+01,0.2166E+01,0.2400E+01,
     *0.2661E+01,0.2950E+01,0.3269E+01,0.3621E+01,0.4007E+01,
     *0.4429E+01,0.4888E+01,0.5384E+01,0.5916E+01,0.6482E+01,
     *0.7077E+01,0.7692E+01,0.8315E+01,0.8925E+01,0.9492E+01,
     *0.9968E+01,0.1028E+02,0.1037E+02 /
        DATA ((PHR(i,j),j=1,83),i=13,13)/
     *0.2928E+00,0.2910E+00,0.2838E+00,0.2731E+00,0.2614E+00,
     *0.2506E+00,0.2418E+00,0.2353E+00,0.2306E+00,0.2272E+00,
     *0.2242E+00,0.2214E+00,0.2184E+00,0.2153E+00,0.2121E+00,
     *0.2089E+00,0.2057E+00,0.2027E+00,0.1999E+00,0.1974E+00,
     *0.1954E+00,0.1938E+00,0.1927E+00,0.1922E+00,0.1922E+00,
     *0.1929E+00,0.1942E+00,0.1962E+00,0.1990E+00,0.2026E+00,
     *0.2070E+00,0.2125E+00,0.2189E+00,0.2264E+00,0.2351E+00,
     *0.2452E+00,0.2566E+00,0.2697E+00,0.2844E+00,0.3011E+00,
     *0.3199E+00,0.3301E+00,0.3409E+00,0.3646E+00,0.3911E+00,
     *0.4207E+00,0.4538E+00,0.4908E+00,0.5321E+00,0.5782E+00,
     *0.6297E+00,0.6871E+00,0.7512E+00,0.8227E+00,0.9024E+00,
     *0.9912E+00,0.1090E+01,0.1201E+01,0.1324E+01,0.1461E+01,
     *0.1613E+01,0.1783E+01,0.1972E+01,0.2181E+01,0.2413E+01,
     *0.2670E+01,0.2953E+01,0.3265E+01,0.3607E+01,0.3982E+01,
     *0.4389E+01,0.4830E+01,0.5305E+01,0.5811E+01,0.6345E+01,
     *0.6902E+01,0.7473E+01,0.8045E+01,0.8599E+01,0.9107E+01,
     *0.9527E+01,0.9801E+01,0.9873E+01 /
        DATA ((PHR(i,j),j=1,83),i=14,14)/
     *0.2827E+00,0.2814E+00,0.2762E+00,0.2683E+00,0.2596E+00,
     *0.2514E+00,0.2446E+00,0.2394E+00,0.2354E+00,0.2323E+00,
     *0.2295E+00,0.2268E+00,0.2240E+00,0.2211E+00,0.2182E+00,
     *0.2152E+00,0.2122E+00,0.2095E+00,0.2069E+00,0.2047E+00,
     *0.2028E+00,0.2014E+00,0.2004E+00,0.2000E+00,0.2001E+00,
     *0.2008E+00,0.2022E+00,0.2042E+00,0.2071E+00,0.2107E+00,
     *0.2152E+00,0.2207E+00,0.2273E+00,0.2349E+00,0.2438E+00,
     *0.2540E+00,0.2657E+00,0.2790E+00,0.2941E+00,0.3112E+00,
     *0.3303E+00,0.3408E+00,0.3519E+00,0.3761E+00,0.4032E+00,
     *0.4335E+00,0.4673E+00,0.5051E+00,0.5472E+00,0.5942E+00,
     *0.6466E+00,0.7049E+00,0.7699E+00,0.8422E+00,0.9228E+00,
     *0.1012E+01,0.1112E+01,0.1223E+01,0.1346E+01,0.1483E+01,
     *0.1635E+01,0.1803E+01,0.1990E+01,0.2196E+01,0.2425E+01,
     *0.2676E+01,0.2952E+01,0.3255E+01,0.3587E+01,0.3947E+01,
     *0.4337E+01,0.4757E+01,0.5206E+01,0.5681E+01,0.6178E+01,
     *0.6692E+01,0.7213E+01,0.7728E+01,0.8219E+01,0.8660E+01,
     *0.9018E+01,0.9246E+01,0.9304E+01 /
        DATA ((PHR(i,j),j=1,83),i=15,15)/
     *0.3014E+00,0.3009E+00,0.2986E+00,0.2950E+00,0.2907E+00,
     *0.2863E+00,0.2822E+00,0.2785E+00,0.2752E+00,0.2722E+00,
     *0.2693E+00,0.2665E+00,0.2637E+00,0.2608E+00,0.2579E+00,
     *0.2551E+00,0.2523E+00,0.2497E+00,0.2473E+00,0.2451E+00,
     *0.2433E+00,0.2418E+00,0.2408E+00,0.2402E+00,0.2401E+00,
     *0.2407E+00,0.2419E+00,0.2439E+00,0.2466E+00,0.2502E+00,
     *0.2547E+00,0.2603E+00,0.2670E+00,0.2749E+00,0.2842E+00,
     *0.2950E+00,0.3073E+00,0.3215E+00,0.3376E+00,0.3558E+00,
     *0.3763E+00,0.3875E+00,0.3993E+00,0.4252E+00,0.4541E+00,
     *0.4864E+00,0.5223E+00,0.5623E+00,0.6067E+00,0.6560E+00,
     *0.7106E+00,0.7711E+00,0.8380E+00,0.9120E+00,0.9936E+00,
     *0.1084E+01,0.1183E+01,0.1293E+01,0.1413E+01,0.1545E+01,
     *0.1691E+01,0.1850E+01,0.2024E+01,0.2215E+01,0.2423E+01,
     *0.2649E+01,0.2893E+01,0.3158E+01,0.3443E+01,0.3747E+01,
     *0.4071E+01,0.4413E+01,0.4772E+01,0.5143E+01,0.5523E+01,
     *0.5905E+01,0.6281E+01,0.6641E+01,0.6971E+01,0.7255E+01,
     *0.7473E+01,0.7606E+01,0.7638E+01 /
        DATA ((PHR(i,j),j=1,83),i=16,16)/
     *0.3262E+00,0.3259E+00,0.3249E+00,0.3232E+00,0.3210E+00,
     *0.3186E+00,0.3161E+00,0.3133E+00,0.3105E+00,0.3074E+00,
     *0.3042E+00,0.3008E+00,0.2973E+00,0.2937E+00,0.2901E+00,
     *0.2865E+00,0.2829E+00,0.2796E+00,0.2764E+00,0.2734E+00,
     *0.2707E+00,0.2683E+00,0.2664E+00,0.2648E+00,0.2638E+00,
     *0.2633E+00,0.2635E+00,0.2643E+00,0.2659E+00,0.2683E+00,
     *0.2717E+00,0.2760E+00,0.2815E+00,0.2882E+00,0.2963E+00,
     *0.3059E+00,0.3170E+00,0.3299E+00,0.3448E+00,0.3618E+00,
     *0.3812E+00,0.3918E+00,0.4031E+00,0.4278E+00,0.4556E+00,
     *0.4867E+00,0.5216E+00,0.5604E+00,0.6037E+00,0.6519E+00,
     *0.7053E+00,0.7646E+00,0.8302E+00,0.9027E+00,0.9829E+00,
     *0.1071E+01,0.1169E+01,0.1276E+01,0.1395E+01,0.1525E+01,
     *0.1668E+01,0.1824E+01,0.1996E+01,0.2183E+01,0.2387E+01,
     *0.2610E+01,0.2851E+01,0.3112E+01,0.3394E+01,0.3695E+01,
     *0.4016E+01,0.4356E+01,0.4712E+01,0.5081E+01,0.5458E+01,
     *0.5837E+01,0.6209E+01,0.6563E+01,0.6885E+01,0.7159E+01,
     *0.7368E+01,0.7493E+01,0.7523E+01 /
        DATA ((PHR(i,j),j=1,83),i=17,17)/
     *0.3448E+00,0.3446E+00,0.3435E+00,0.3418E+00,0.3396E+00,
     *0.3371E+00,0.3344E+00,0.3315E+00,0.3285E+00,0.3252E+00,
     *0.3218E+00,0.3182E+00,0.3144E+00,0.3106E+00,0.3067E+00,
     *0.3029E+00,0.2991E+00,0.2955E+00,0.2920E+00,0.2888E+00,
     *0.2858E+00,0.2832E+00,0.2809E+00,0.2791E+00,0.2778E+00,
     *0.2771E+00,0.2770E+00,0.2776E+00,0.2790E+00,0.2812E+00,
     *0.2844E+00,0.2886E+00,0.2940E+00,0.3007E+00,0.3087E+00,
     *0.3182E+00,0.3293E+00,0.3423E+00,0.3573E+00,0.3744E+00,
     *0.3939E+00,0.4046E+00,0.4160E+00,0.4409E+00,0.4689E+00,
     *0.5002E+00,0.5353E+00,0.5744E+00,0.6179E+00,0.6662E+00,
     *0.7198E+00,0.7791E+00,0.8447E+00,0.9172E+00,0.9970E+00,
     *0.1085E+01,0.1182E+01,0.1288E+01,0.1405E+01,0.1533E+01,
     *0.1673E+01,0.1827E+01,0.1994E+01,0.2177E+01,0.2375E+01,
     *0.2590E+01,0.2823E+01,0.3074E+01,0.3343E+01,0.3631E+01,
     *0.3936E+01,0.4257E+01,0.4593E+01,0.4939E+01,0.5291E+01,
     *0.5643E+01,0.5987E+01,0.6312E+01,0.6606E+01,0.6855E+01,
     *0.7043E+01,0.7155E+01,0.7182E+01 /
        DATA ((PHR(i,j),j=1,83),i=18,18)/
     *0.3923E+00,0.3921E+00,0.3915E+00,0.3903E+00,0.3888E+00,
     *0.3868E+00,0.3846E+00,0.3820E+00,0.3791E+00,0.3760E+00,
     *0.3727E+00,0.3692E+00,0.3655E+00,0.3617E+00,0.3579E+00,
     *0.3540E+00,0.3501E+00,0.3463E+00,0.3427E+00,0.3392E+00,
     *0.3359E+00,0.3329E+00,0.3302E+00,0.3280E+00,0.3262E+00,
     *0.3250E+00,0.3244E+00,0.3245E+00,0.3254E+00,0.3272E+00,
     *0.3300E+00,0.3338E+00,0.3388E+00,0.3451E+00,0.3529E+00,
     *0.3622E+00,0.3733E+00,0.3863E+00,0.4012E+00,0.4185E+00,
     *0.4381E+00,0.4490E+00,0.4605E+00,0.4856E+00,0.5140E+00,
     *0.5456E+00,0.5810E+00,0.6204E+00,0.6640E+00,0.7123E+00,
     *0.7657E+00,0.8245E+00,0.8892E+00,0.9602E+00,0.1038E+01,
     *0.1123E+01,0.1216E+01,0.1318E+01,0.1429E+01,0.1549E+01,
     *0.1680E+01,0.1822E+01,0.1975E+01,0.2140E+01,0.2318E+01,
     *0.2510E+01,0.2714E+01,0.2932E+01,0.3164E+01,0.3409E+01,
     *0.3666E+01,0.3933E+01,0.4209E+01,0.4491E+01,0.4775E+01,
     *0.5056E+01,0.5328E+01,0.5582E+01,0.5809E+01,0.6000E+01,
     *0.6143E+01,0.6227E+01,0.6248E+01 /
        DATA ((PHR(i,j),j=1,83),i=19,19)/
     *0.4345E+00,0.4343E+00,0.4335E+00,0.4322E+00,0.4304E+00,
     *0.4281E+00,0.4254E+00,0.4224E+00,0.4190E+00,0.4154E+00,
     *0.4114E+00,0.4073E+00,0.4030E+00,0.3985E+00,0.3939E+00,
     *0.3893E+00,0.3847E+00,0.3801E+00,0.3756E+00,0.3713E+00,
     *0.3673E+00,0.3635E+00,0.3600E+00,0.3570E+00,0.3545E+00,
     *0.3526E+00,0.3513E+00,0.3507E+00,0.3510E+00,0.3522E+00,
     *0.3544E+00,0.3577E+00,0.3623E+00,0.3682E+00,0.3756E+00,
     *0.3847E+00,0.3955E+00,0.4082E+00,0.4231E+00,0.4402E+00,
     *0.4599E+00,0.4707E+00,0.4822E+00,0.5074E+00,0.5357E+00,
     *0.5674E+00,0.6028E+00,0.6421E+00,0.6857E+00,0.7338E+00,
     *0.7869E+00,0.8452E+00,0.9092E+00,0.9792E+00,0.1056E+01,
     *0.1139E+01,0.1230E+01,0.1329E+01,0.1436E+01,0.1552E+01,
     *0.1678E+01,0.1813E+01,0.1959E+01,0.2115E+01,0.2283E+01,
     *0.2462E+01,0.2652E+01,0.2854E+01,0.3066E+01,0.3289E+01,
     *0.3522E+01,0.3762E+01,0.4009E+01,0.4258E+01,0.4506E+01,
     *0.4750E+01,0.4983E+01,0.5199E+01,0.5390E+01,0.5548E+01,
     *0.5666E+01,0.5734E+01,0.5750E+01 /
        DATA ((PHR(i,j),j=1,83),i=20,20)/
     *0.6107E+00,0.6105E+00,0.6093E+00,0.6073E+00,0.6045E+00,
     *0.6010E+00,0.5968E+00,0.5921E+00,0.5869E+00,0.5811E+00,
     *0.5750E+00,0.5684E+00,0.5615E+00,0.5543E+00,0.5469E+00,
     *0.5393E+00,0.5316E+00,0.5239E+00,0.5163E+00,0.5087E+00,
     *0.5014E+00,0.4943E+00,0.4876E+00,0.4814E+00,0.4757E+00,
     *0.4706E+00,0.4663E+00,0.4628E+00,0.4603E+00,0.4587E+00,
     *0.4584E+00,0.4593E+00,0.4617E+00,0.4655E+00,0.4711E+00,
     *0.4784E+00,0.4877E+00,0.4990E+00,0.5126E+00,0.5286E+00,
     *0.5471E+00,0.5574E+00,0.5684E+00,0.5926E+00,0.6198E+00,
     *0.6503E+00,0.6842E+00,0.7218E+00,0.7633E+00,0.8087E+00,
     *0.8584E+00,0.9125E+00,0.9713E+00,0.1035E+01,0.1103E+01,
     *0.1177E+01,0.1256E+01,0.1341E+01,0.1432E+01,0.1528E+01,
     *0.1630E+01,0.1738E+01,0.1852E+01,0.1972E+01,0.2098E+01,
     *0.2229E+01,0.2365E+01,0.2506E+01,0.2651E+01,0.2798E+01,
     *0.2948E+01,0.3099E+01,0.3248E+01,0.3395E+01,0.3538E+01,
     *0.3672E+01,0.3797E+01,0.3909E+01,0.4005E+01,0.4082E+01,
     *0.4138E+01,0.4170E+01,0.4177E+01 /
c************** MIE (phase fun qh) ***************
        DATA ((QHR(i,j),j=1,83),i= 1, 1)/
     * 0.3270E-21, 0.3207E-02, 0.1530E-01, 0.3251E-01, 0.5092E-01,
     * 0.6799E-01, 0.8225E-01, 0.9280E-01, 0.9921E-01, 0.1015E+00,
     * 0.1000E+00, 0.9567E-01, 0.8939E-01, 0.8197E-01, 0.7410E-01,
     * 0.6626E-01, 0.5870E-01, 0.5152E-01, 0.4482E-01, 0.3867E-01,
     * 0.3310E-01, 0.2806E-01, 0.2347E-01, 0.1923E-01, 0.1529E-01,
     * 0.1167E-01, 0.8357E-02, 0.5291E-02, 0.2424E-02,-0.2987E-03,
     *-0.2903E-02,-0.5337E-02,-0.7573E-02,-0.9691E-02,-0.1178E-01,
     *-0.1383E-01,-0.1578E-01,-0.1759E-01,-0.1927E-01,-0.2086E-01,
     *-0.2249E-01,-0.2333E-01,-0.2417E-01,-0.2574E-01,-0.2702E-01,
     *-0.2805E-01,-0.2900E-01,-0.3001E-01,-0.3105E-01,-0.3198E-01,
     *-0.3260E-01,-0.3277E-01,-0.3258E-01,-0.3228E-01,-0.3202E-01,
     *-0.3162E-01,-0.3082E-01,-0.2951E-01,-0.2774E-01,-0.2560E-01,
     *-0.2325E-01,-0.2070E-01,-0.1785E-01,-0.1456E-01,-0.1079E-01,
     *-0.6552E-02,-0.2046E-02, 0.2427E-02, 0.6831E-02, 0.1125E-01,
     * 0.1556E-01, 0.1973E-01, 0.2378E-01, 0.2733E-01, 0.3014E-01,
     * 0.3208E-01, 0.3229E-01, 0.3032E-01, 0.2608E-01, 0.1884E-01,
     * 0.9652E-02, 0.2171E-02, 0.5166E-20 /
        DATA ((QHR(i,j),j=1,83),i= 2, 2)/
     * 0.3072E-21, 0.2568E-02, 0.1248E-01, 0.2717E-01, 0.4360E-01,
     * 0.5948E-01, 0.7318E-01, 0.8356E-01, 0.8997E-01, 0.9239E-01,
     * 0.9131E-01, 0.8754E-01, 0.8199E-01, 0.7541E-01, 0.6836E-01,
     * 0.6119E-01, 0.5410E-01, 0.4726E-01, 0.4077E-01, 0.3471E-01,
     * 0.2911E-01, 0.2394E-01, 0.1912E-01, 0.1461E-01, 0.1033E-01,
     * 0.6317E-02, 0.2599E-02,-0.8265E-03,-0.4024E-02,-0.7076E-02,
     *-0.1005E-01,-0.1294E-01,-0.1570E-01,-0.1828E-01,-0.2072E-01,
     *-0.2309E-01,-0.2543E-01,-0.2774E-01,-0.2999E-01,-0.3213E-01,
     *-0.3416E-01,-0.3515E-01,-0.3613E-01,-0.3805E-01,-0.3986E-01,
     *-0.4152E-01,-0.4304E-01,-0.4445E-01,-0.4578E-01,-0.4704E-01,
     *-0.4816E-01,-0.4900E-01,-0.4946E-01,-0.4956E-01,-0.4941E-01,
     *-0.4911E-01,-0.4863E-01,-0.4784E-01,-0.4660E-01,-0.4486E-01,
     *-0.4262E-01,-0.3988E-01,-0.3672E-01,-0.3327E-01,-0.2954E-01,
     *-0.2550E-01,-0.2110E-01,-0.1625E-01,-0.1094E-01,-0.5391E-02,
     * 0.1815E-03, 0.5608E-02, 0.1045E-01, 0.1427E-01, 0.1684E-01,
     * 0.1791E-01, 0.1747E-01, 0.1587E-01, 0.1318E-01, 0.9121E-02,
     * 0.4451E-02, 0.9663E-03, 0.1243E-19 /
        DATA ((QHR(i,j),j=1,83),i= 3, 3)/
     *-0.5665E-22, 0.2492E-02, 0.1212E-01, 0.2642E-01, 0.4246E-01,
     * 0.5794E-01, 0.7122E-01, 0.8128E-01, 0.8756E-01, 0.9004E-01,
     * 0.8915E-01, 0.8559E-01, 0.8022E-01, 0.7380E-01, 0.6691E-01,
     * 0.5987E-01, 0.5292E-01, 0.4619E-01, 0.3981E-01, 0.3380E-01,
     * 0.2818E-01, 0.2292E-01, 0.1800E-01, 0.1342E-01, 0.9128E-02,
     * 0.5096E-02, 0.1309E-02,-0.2246E-02,-0.5601E-02,-0.8780E-02,
     *-0.1181E-01,-0.1475E-01,-0.1759E-01,-0.2031E-01,-0.2290E-01,
     *-0.2540E-01,-0.2785E-01,-0.3026E-01,-0.3261E-01,-0.3487E-01,
     *-0.3701E-01,-0.3802E-01,-0.3901E-01,-0.4096E-01,-0.4291E-01,
     *-0.4481E-01,-0.4656E-01,-0.4810E-01,-0.4943E-01,-0.5059E-01,
     *-0.5164E-01,-0.5263E-01,-0.5344E-01,-0.5387E-01,-0.5384E-01,
     *-0.5345E-01,-0.5284E-01,-0.5203E-01,-0.5091E-01,-0.4937E-01,
     *-0.4726E-01,-0.4454E-01,-0.4131E-01,-0.3774E-01,-0.3391E-01,
     *-0.2990E-01,-0.2558E-01,-0.2068E-01,-0.1509E-01,-0.9021E-02,
     *-0.2838E-02, 0.3017E-02, 0.8104E-02, 0.1235E-01, 0.1563E-01,
     * 0.1744E-01, 0.1760E-01, 0.1610E-01, 0.1301E-01, 0.9100E-02,
     * 0.4953E-02, 0.1210E-02, 0.1736E-19 /
        DATA ((QHR(i,j),j=1,83),i= 4, 4)/
     *-0.2285E-21, 0.2245E-02, 0.1099E-01, 0.2411E-01, 0.3901E-01,
     * 0.5358E-01, 0.6628E-01, 0.7605E-01, 0.8227E-01, 0.8487E-01,
     * 0.8424E-01, 0.8108E-01, 0.7617E-01, 0.7019E-01, 0.6366E-01,
     * 0.5689E-01, 0.5012E-01, 0.4349E-01, 0.3712E-01, 0.3110E-01,
     * 0.2545E-01, 0.2016E-01, 0.1517E-01, 0.1046E-01, 0.5972E-02,
     * 0.1719E-02,-0.2273E-02,-0.6013E-02,-0.9552E-02,-0.1295E-01,
     *-0.1626E-01,-0.1949E-01,-0.2260E-01,-0.2556E-01,-0.2840E-01,
     *-0.3116E-01,-0.3389E-01,-0.3659E-01,-0.3923E-01,-0.4177E-01,
     *-0.4420E-01,-0.4539E-01,-0.4656E-01,-0.4886E-01,-0.5107E-01,
     *-0.5316E-01,-0.5510E-01,-0.5691E-01,-0.5859E-01,-0.6017E-01,
     *-0.6160E-01,-0.6279E-01,-0.6363E-01,-0.6410E-01,-0.6425E-01,
     *-0.6416E-01,-0.6383E-01,-0.6318E-01,-0.6207E-01,-0.6043E-01,
     *-0.5823E-01,-0.5545E-01,-0.5217E-01,-0.4850E-01,-0.4447E-01,
     *-0.4006E-01,-0.3520E-01,-0.2982E-01,-0.2387E-01,-0.1759E-01,
     *-0.1121E-01,-0.4967E-02, 0.7145E-03, 0.5468E-02, 0.9077E-02,
     * 0.1128E-01, 0.1205E-01, 0.1158E-01, 0.9914E-02, 0.7016E-02,
     * 0.3530E-02, 0.7827E-03,-0.3524E-20 /
        DATA ((QHR(i,j),j=1,83),i= 5, 5)/
     *-0.1177E-21, 0.2156E-02, 0.1051E-01, 0.2298E-01, 0.3702E-01,
     * 0.5062E-01, 0.6240E-01, 0.7150E-01, 0.7740E-01, 0.8003E-01,
     * 0.7972E-01, 0.7706E-01, 0.7265E-01, 0.6706E-01, 0.6076E-01,
     * 0.5413E-01, 0.4748E-01, 0.4101E-01, 0.3482E-01, 0.2888E-01,
     * 0.2318E-01, 0.1774E-01, 0.1260E-01, 0.7783E-02, 0.3261E-02,
     *-0.1037E-02,-0.5180E-02,-0.9181E-02,-0.1302E-01,-0.1669E-01,
     *-0.2018E-01,-0.2354E-01,-0.2685E-01,-0.3010E-01,-0.3326E-01,
     *-0.3632E-01,-0.3930E-01,-0.4219E-01,-0.4504E-01,-0.4783E-01,
     *-0.5051E-01,-0.5181E-01,-0.5308E-01,-0.5557E-01,-0.5804E-01,
     *-0.6048E-01,-0.6279E-01,-0.6488E-01,-0.6672E-01,-0.6833E-01,
     *-0.6976E-01,-0.7108E-01,-0.7229E-01,-0.7324E-01,-0.7376E-01,
     *-0.7378E-01,-0.7333E-01,-0.7251E-01,-0.7135E-01,-0.6979E-01,
     *-0.6770E-01,-0.6503E-01,-0.6179E-01,-0.5797E-01,-0.5359E-01,
     *-0.4867E-01,-0.4324E-01,-0.3733E-01,-0.3110E-01,-0.2463E-01,
     *-0.1790E-01,-0.1103E-01,-0.4190E-02, 0.2318E-02, 0.7880E-02,
     * 0.1185E-01, 0.1387E-01, 0.1371E-01, 0.1150E-01, 0.8198E-02,
     * 0.4490E-02, 0.1092E-02,-0.3760E-19 /
        DATA ((QHR(i,j),j=1,83),i= 6, 6)/
     *-0.3107E-21, 0.2010E-02, 0.9860E-02, 0.2170E-01, 0.3518E-01,
     * 0.4841E-01, 0.6001E-01, 0.6903E-01, 0.7494E-01, 0.7767E-01,
     * 0.7748E-01, 0.7492E-01, 0.7063E-01, 0.6518E-01, 0.5905E-01,
     * 0.5258E-01, 0.4602E-01, 0.3953E-01, 0.3321E-01, 0.2718E-01,
     * 0.2148E-01, 0.1608E-01, 0.1096E-01, 0.6063E-02, 0.1359E-02,
     *-0.3135E-02,-0.7400E-02,-0.1144E-01,-0.1531E-01,-0.1906E-01,
     *-0.2274E-01,-0.2633E-01,-0.2979E-01,-0.3312E-01,-0.3636E-01,
     *-0.3955E-01,-0.4270E-01,-0.4579E-01,-0.4879E-01,-0.5172E-01,
     *-0.5459E-01,-0.5602E-01,-0.5744E-01,-0.6020E-01,-0.6279E-01,
     *-0.6518E-01,-0.6745E-01,-0.6966E-01,-0.7182E-01,-0.7386E-01,
     *-0.7564E-01,-0.7703E-01,-0.7801E-01,-0.7871E-01,-0.7920E-01,
     *-0.7945E-01,-0.7934E-01,-0.7872E-01,-0.7753E-01,-0.7578E-01,
     *-0.7351E-01,-0.7070E-01,-0.6734E-01,-0.6342E-01,-0.5892E-01,
     *-0.5381E-01,-0.4817E-01,-0.4211E-01,-0.3569E-01,-0.2900E-01,
     *-0.2214E-01,-0.1526E-01,-0.8605E-02,-0.2624E-02, 0.2332E-02,
     * 0.6005E-02, 0.8157E-02, 0.8858E-02, 0.8231E-02, 0.6104E-02,
     * 0.3074E-02, 0.6670E-03, 0.2643E-19 /
        DATA ((QHR(i,j),j=1,83),i= 7, 7)/
     *-0.3274E-21, 0.1817E-02, 0.8970E-02, 0.1991E-01, 0.3254E-01,
     * 0.4511E-01, 0.5626E-01, 0.6501E-01, 0.7079E-01, 0.7350E-01,
     * 0.7340E-01, 0.7102E-01, 0.6697E-01, 0.6180E-01, 0.5594E-01,
     * 0.4972E-01, 0.4334E-01, 0.3698E-01, 0.3075E-01, 0.2475E-01,
     * 0.1902E-01, 0.1355E-01, 0.8329E-02, 0.3308E-02,-0.1532E-02,
     *-0.6182E-02,-0.1062E-01,-0.1485E-01,-0.1891E-01,-0.2286E-01,
     *-0.2673E-01,-0.3053E-01,-0.3422E-01,-0.3778E-01,-0.4125E-01,
     *-0.4465E-01,-0.4801E-01,-0.5134E-01,-0.5460E-01,-0.5777E-01,
     *-0.6086E-01,-0.6238E-01,-0.6388E-01,-0.6683E-01,-0.6966E-01,
     *-0.7234E-01,-0.7487E-01,-0.7728E-01,-0.7958E-01,-0.8174E-01,
     *-0.8369E-01,-0.8533E-01,-0.8658E-01,-0.8748E-01,-0.8805E-01,
     *-0.8833E-01,-0.8827E-01,-0.8776E-01,-0.8671E-01,-0.8505E-01,
     *-0.8278E-01,-0.7988E-01,-0.7638E-01,-0.7232E-01,-0.6770E-01,
     *-0.6252E-01,-0.5675E-01,-0.5042E-01,-0.4355E-01,-0.3630E-01,
     *-0.2885E-01,-0.2139E-01,-0.1428E-01,-0.7920E-02,-0.2621E-02,
     * 0.1348E-02, 0.3877E-02, 0.5104E-02, 0.5129E-02, 0.3927E-02,
     * 0.2011E-02, 0.4411E-03,-0.1732E-19 /
        DATA ((QHR(i,j),j=1,83),i= 8, 8)/
     * 0.7827E-21, 0.1678E-02, 0.8272E-02, 0.1831E-01, 0.2982E-01,
     * 0.4118E-01, 0.5122E-01, 0.5917E-01, 0.6459E-01, 0.6734E-01,
     * 0.6758E-01, 0.6569E-01, 0.6212E-01, 0.5734E-01, 0.5176E-01,
     * 0.4575E-01, 0.3956E-01, 0.3337E-01, 0.2726E-01, 0.2130E-01,
     * 0.1553E-01, 0.9959E-02, 0.4604E-02,-0.5389E-03,-0.5472E-02,
     *-0.1022E-01,-0.1482E-01,-0.1930E-01,-0.2368E-01,-0.2795E-01,
     *-0.3208E-01,-0.3610E-01,-0.4003E-01,-0.4392E-01,-0.4776E-01,
     *-0.5153E-01,-0.5521E-01,-0.5880E-01,-0.6233E-01,-0.6581E-01,
     *-0.6923E-01,-0.7092E-01,-0.7257E-01,-0.7580E-01,-0.7891E-01,
     *-0.8192E-01,-0.8482E-01,-0.8757E-01,-0.9011E-01,-0.9242E-01,
     *-0.9447E-01,-0.9628E-01,-0.9782E-01,-0.9906E-01,-0.9995E-01,
     *-0.1004E+00,-0.1003E+00,-0.9973E-01,-0.9856E-01,-0.9684E-01,
     *-0.9456E-01,-0.9172E-01,-0.8822E-01,-0.8396E-01,-0.7892E-01,
     *-0.7313E-01,-0.6667E-01,-0.5971E-01,-0.5239E-01,-0.4477E-01,
     *-0.3691E-01,-0.2889E-01,-0.2082E-01,-0.1297E-01,-0.5784E-02,
     * 0.2719E-03, 0.4674E-02, 0.7019E-02, 0.7265E-02, 0.5707E-02,
     * 0.3083E-02, 0.7031E-03,-0.1986E-19 /
        DATA ((QHR(i,j),j=1,83),i= 9, 9)/
     * 0.1904E-21, 0.1502E-02, 0.7441E-02, 0.1659E-01, 0.2725E-01,
     * 0.3791E-01, 0.4742E-01, 0.5500E-01, 0.6017E-01, 0.6280E-01,
     * 0.6304E-01, 0.6125E-01, 0.5787E-01, 0.5333E-01, 0.4800E-01,
     * 0.4218E-01, 0.3614E-01, 0.3004E-01, 0.2399E-01, 0.1803E-01,
     * 0.1219E-01, 0.6484E-02, 0.9587E-03,-0.4373E-02,-0.9519E-02,
     *-0.1451E-01,-0.1939E-01,-0.2416E-01,-0.2880E-01,-0.3333E-01,
     *-0.3774E-01,-0.4206E-01,-0.4632E-01,-0.5053E-01,-0.5467E-01,
     *-0.5873E-01,-0.6272E-01,-0.6665E-01,-0.7052E-01,-0.7431E-01,
     *-0.7802E-01,-0.7983E-01,-0.8161E-01,-0.8513E-01,-0.8857E-01,
     *-0.9192E-01,-0.9512E-01,-0.9810E-01,-0.1008E+00,-0.1033E+00,
     *-0.1056E+00,-0.1077E+00,-0.1095E+00,-0.1109E+00,-0.1119E+00,
     *-0.1124E+00,-0.1123E+00,-0.1118E+00,-0.1107E+00,-0.1090E+00,
     *-0.1067E+00,-0.1036E+00,-0.9986E-01,-0.9534E-01,-0.9009E-01,
     *-0.8412E-01,-0.7745E-01,-0.7012E-01,-0.6223E-01,-0.5388E-01,
     *-0.4520E-01,-0.3637E-01,-0.2761E-01,-0.1923E-01,-0.1167E-01,
     *-0.5415E-02,-0.8093E-03, 0.1951E-02, 0.2941E-02, 0.2675E-02,
     * 0.1652E-02, 0.4204E-03, 0.1092E-19 /
        DATA ((QHR(i,j),j=1,83),i=10,10)/
     * 0.7601E-21, 0.1298E-02, 0.6480E-02, 0.1459E-01, 0.2420E-01,
     * 0.3396E-01, 0.4280E-01, 0.4993E-01, 0.5485E-01, 0.5739E-01,
     * 0.5768E-01, 0.5603E-01, 0.5284E-01, 0.4854E-01, 0.4347E-01,
     * 0.3790E-01, 0.3202E-01, 0.2600E-01, 0.1995E-01, 0.1396E-01,
     * 0.8058E-02, 0.2279E-02,-0.3369E-02,-0.8884E-02,-0.1427E-01,
     *-0.1953E-01,-0.2467E-01,-0.2968E-01,-0.3458E-01,-0.3939E-01,
     *-0.4412E-01,-0.4879E-01,-0.5339E-01,-0.5791E-01,-0.6236E-01,
     *-0.6674E-01,-0.7108E-01,-0.7536E-01,-0.7959E-01,-0.8373E-01,
     *-0.8778E-01,-0.8976E-01,-0.9172E-01,-0.9557E-01,-0.9932E-01,
     *-0.1029E+00,-0.1064E+00,-0.1097E+00,-0.1127E+00,-0.1155E+00,
     *-0.1181E+00,-0.1204E+00,-0.1223E+00,-0.1238E+00,-0.1248E+00,
     *-0.1254E+00,-0.1255E+00,-0.1250E+00,-0.1240E+00,-0.1222E+00,
     *-0.1197E+00,-0.1165E+00,-0.1124E+00,-0.1076E+00,-0.1020E+00,
     *-0.9576E-01,-0.8875E-01,-0.8098E-01,-0.7249E-01,-0.6342E-01,
     *-0.5400E-01,-0.4452E-01,-0.3530E-01,-0.2664E-01,-0.1881E-01,
     *-0.1215E-01,-0.6858E-02,-0.3038E-02,-0.6839E-03, 0.3868E-03,
     * 0.5016E-03, 0.1542E-03,-0.1453E-19 /
        DATA ((QHR(i,j),j=1,83),i=11,11)/
     *-0.8737E-22, 0.1206E-02, 0.6014E-02, 0.1353E-01, 0.2241E-01,
     * 0.3142E-01, 0.3958E-01, 0.4619E-01, 0.5079E-01, 0.5322E-01,
     * 0.5355E-01, 0.5206E-01, 0.4908E-01, 0.4496E-01, 0.4002E-01,
     * 0.3454E-01, 0.2873E-01, 0.2276E-01, 0.1674E-01, 0.1072E-01,
     * 0.4747E-02,-0.1154E-02,-0.6948E-02,-0.1262E-01,-0.1815E-01,
     *-0.2359E-01,-0.2893E-01,-0.3419E-01,-0.3936E-01,-0.4445E-01,
     *-0.4944E-01,-0.5435E-01,-0.5922E-01,-0.6404E-01,-0.6880E-01,
     *-0.7349E-01,-0.7812E-01,-0.8267E-01,-0.8717E-01,-0.9159E-01,
     *-0.9591E-01,-0.9803E-01,-0.1001E+00,-0.1042E+00,-0.1082E+00,
     *-0.1121E+00,-0.1158E+00,-0.1193E+00,-0.1226E+00,-0.1255E+00,
     *-0.1282E+00,-0.1306E+00,-0.1327E+00,-0.1344E+00,-0.1356E+00,
     *-0.1362E+00,-0.1363E+00,-0.1357E+00,-0.1345E+00,-0.1327E+00,
     *-0.1301E+00,-0.1267E+00,-0.1225E+00,-0.1174E+00,-0.1115E+00,
     *-0.1048E+00,-0.9726E-01,-0.8897E-01,-0.8004E-01,-0.7058E-01,
     *-0.6073E-01,-0.5069E-01,-0.4067E-01,-0.3100E-01,-0.2207E-01,
     *-0.1433E-01,-0.8122E-02,-0.3659E-02,-0.9475E-03, 0.3168E-03,
     * 0.5233E-03, 0.1689E-03,-0.2604E-19 /
        DATA ((QHR(i,j),j=1,83),i=12,12)/
     *-0.1387E-21, 0.1144E-02, 0.5715E-02, 0.1287E-01, 0.2135E-01,
     * 0.2998E-01, 0.3782E-01, 0.4420E-01, 0.4867E-01, 0.5106E-01,
     * 0.5141E-01, 0.4997E-01, 0.4705E-01, 0.4298E-01, 0.3810E-01,
     * 0.3266E-01, 0.2687E-01, 0.2087E-01, 0.1479E-01, 0.8703E-02,
     * 0.2670E-02,-0.3281E-02,-0.9142E-02,-0.1491E-01,-0.2059E-01,
     *-0.2617E-01,-0.3165E-01,-0.3704E-01,-0.4234E-01,-0.4758E-01,
     *-0.5276E-01,-0.5787E-01,-0.6290E-01,-0.6788E-01,-0.7280E-01,
     *-0.7767E-01,-0.8248E-01,-0.8722E-01,-0.9188E-01,-0.9647E-01,
     *-0.1010E+00,-0.1032E+00,-0.1054E+00,-0.1097E+00,-0.1139E+00,
     *-0.1178E+00,-0.1216E+00,-0.1252E+00,-0.1287E+00,-0.1318E+00,
     *-0.1347E+00,-0.1371E+00,-0.1392E+00,-0.1408E+00,-0.1420E+00,
     *-0.1427E+00,-0.1428E+00,-0.1423E+00,-0.1410E+00,-0.1391E+00,
     *-0.1363E+00,-0.1328E+00,-0.1284E+00,-0.1232E+00,-0.1170E+00,
     *-0.1100E+00,-0.1021E+00,-0.9358E-01,-0.8439E-01,-0.7467E-01,
     *-0.6457E-01,-0.5430E-01,-0.4408E-01,-0.3425E-01,-0.2514E-01,
     *-0.1706E-01,-0.1036E-01,-0.5266E-02,-0.1865E-02,-0.1354E-03,
     * 0.2818E-03, 0.1009E-03,-0.1080E-19 /
        DATA ((QHR(i,j),j=1,83),i=13,13)/
     *-0.5055E-21, 0.9320E-03, 0.4680E-02, 0.1062E-01, 0.1774E-01,
     * 0.2507E-01, 0.3178E-01, 0.3725E-01, 0.4108E-01, 0.4309E-01,
     * 0.4329E-01, 0.4188E-01, 0.3912E-01, 0.3527E-01, 0.3061E-01,
     * 0.2537E-01, 0.1974E-01, 0.1386E-01, 0.7840E-02, 0.1739E-02,
     *-0.4392E-02,-0.1052E-01,-0.1660E-01,-0.2263E-01,-0.2858E-01,
     *-0.3448E-01,-0.4033E-01,-0.4612E-01,-0.5186E-01,-0.5754E-01,
     *-0.6315E-01,-0.6872E-01,-0.7424E-01,-0.7972E-01,-0.8514E-01,
     *-0.9051E-01,-0.9582E-01,-0.1011E+00,-0.1062E+00,-0.1113E+00,
     *-0.1163E+00,-0.1187E+00,-0.1212E+00,-0.1259E+00,-0.1305E+00,
     *-0.1350E+00,-0.1392E+00,-0.1432E+00,-0.1470E+00,-0.1504E+00,
     *-0.1535E+00,-0.1562E+00,-0.1586E+00,-0.1604E+00,-0.1618E+00,
     *-0.1625E+00,-0.1626E+00,-0.1620E+00,-0.1607E+00,-0.1586E+00,
     *-0.1556E+00,-0.1518E+00,-0.1470E+00,-0.1413E+00,-0.1347E+00,
     *-0.1271E+00,-0.1185E+00,-0.1092E+00,-0.9905E-01,-0.8833E-01,
     *-0.7715E-01,-0.6573E-01,-0.5431E-01,-0.4320E-01,-0.3277E-01,
     *-0.2345E-01,-0.1555E-01,-0.9332E-02,-0.4876E-02,-0.2042E-02,
     *-0.5680E-03,-0.6441E-04,-0.2800E-19 /
        DATA ((QHR(i,j),j=1,83),i=14,14)/
     *-0.6295E-21, 0.7026E-03, 0.3544E-02, 0.8087E-02, 0.1358E-01,
     * 0.1926E-01, 0.2445E-01, 0.2863E-01, 0.3144E-01, 0.3272E-01,
     * 0.3248E-01, 0.3084E-01, 0.2800E-01, 0.2418E-01, 0.1960E-01,
     * 0.1443E-01, 0.8843E-02, 0.2958E-02,-0.3134E-02,-0.9368E-02,
     *-0.1569E-01,-0.2207E-01,-0.2848E-01,-0.3488E-01,-0.4128E-01,
     *-0.4766E-01,-0.5404E-01,-0.6039E-01,-0.6673E-01,-0.7304E-01,
     *-0.7931E-01,-0.8556E-01,-0.9178E-01,-0.9796E-01,-0.1041E+00,
     *-0.1102E+00,-0.1162E+00,-0.1222E+00,-0.1281E+00,-0.1339E+00,
     *-0.1396E+00,-0.1424E+00,-0.1452E+00,-0.1506E+00,-0.1558E+00,
     *-0.1609E+00,-0.1657E+00,-0.1703E+00,-0.1745E+00,-0.1784E+00,
     *-0.1819E+00,-0.1850E+00,-0.1876E+00,-0.1897E+00,-0.1912E+00,
     *-0.1920E+00,-0.1921E+00,-0.1914E+00,-0.1899E+00,-0.1875E+00,
     *-0.1841E+00,-0.1797E+00,-0.1743E+00,-0.1679E+00,-0.1603E+00,
     *-0.1517E+00,-0.1420E+00,-0.1314E+00,-0.1199E+00,-0.1077E+00,
     *-0.9501E-01,-0.8198E-01,-0.6888E-01,-0.5606E-01,-0.4388E-01,
     *-0.3273E-01,-0.2298E-01,-0.1490E-01,-0.8663E-02,-0.4266E-02,
     *-0.1564E-02,-0.2702E-03, 0.2095E-19 /
        DATA ((QHR(i,j),j=1,83),i=15,15)/
     *-0.3916E-21, 0.2488E-03, 0.1259E-02, 0.2881E-02, 0.4825E-02,
     * 0.6761E-02, 0.8360E-02, 0.9342E-02, 0.9497E-02, 0.8700E-02,
     * 0.6911E-02, 0.4156E-02, 0.5045E-03,-0.3947E-02,-0.9095E-02,
     *-0.1484E-01,-0.2109E-01,-0.2777E-01,-0.3481E-01,-0.4214E-01,
     *-0.4973E-01,-0.5752E-01,-0.6550E-01,-0.7363E-01,-0.8188E-01,
     *-0.9023E-01,-0.9867E-01,-0.1072E+00,-0.1157E+00,-0.1243E+00,
     *-0.1329E+00,-0.1416E+00,-0.1502E+00,-0.1587E+00,-0.1673E+00,
     *-0.1757E+00,-0.1841E+00,-0.1923E+00,-0.2004E+00,-0.2084E+00,
     *-0.2161E+00,-0.2199E+00,-0.2236E+00,-0.2308E+00,-0.2378E+00,
     *-0.2444E+00,-0.2506E+00,-0.2563E+00,-0.2616E+00,-0.2663E+00,
     *-0.2704E+00,-0.2739E+00,-0.2766E+00,-0.2785E+00,-0.2796E+00,
     *-0.2797E+00,-0.2789E+00,-0.2769E+00,-0.2739E+00,-0.2696E+00,
     *-0.2641E+00,-0.2573E+00,-0.2491E+00,-0.2396E+00,-0.2288E+00,
     *-0.2166E+00,-0.2032E+00,-0.1886E+00,-0.1730E+00,-0.1564E+00,
     *-0.1393E+00,-0.1217E+00,-0.1041E+00,-0.8671E-01,-0.7000E-01,
     *-0.5435E-01,-0.4014E-01,-0.2772E-01,-0.1739E-01,-0.9372E-02,
     *-0.3802E-02,-0.7186E-03, 0.2245E-20 /
        DATA ((QHR(i,j),j=1,83),i=16,16)/
     *-0.8098E-21, 0.3080E-05,-0.6454E-05,-0.1116E-03,-0.4447E-03,
     *-0.1159E-02,-0.2397E-02,-0.4270E-02,-0.6842E-02,-0.1014E-01,
     *-0.1414E-01,-0.1881E-01,-0.2411E-01,-0.2999E-01,-0.3639E-01,
     *-0.4326E-01,-0.5057E-01,-0.5828E-01,-0.6634E-01,-0.7473E-01,
     *-0.8343E-01,-0.9240E-01,-0.1016E+00,-0.1111E+00,-0.1207E+00,
     *-0.1306E+00,-0.1406E+00,-0.1507E+00,-0.1610E+00,-0.1713E+00,
     *-0.1818E+00,-0.1923E+00,-0.2028E+00,-0.2134E+00,-0.2239E+00,
     *-0.2344E+00,-0.2448E+00,-0.2550E+00,-0.2652E+00,-0.2751E+00,
     *-0.2848E+00,-0.2896E+00,-0.2943E+00,-0.3034E+00,-0.3122E+00,
     *-0.3205E+00,-0.3284E+00,-0.3357E+00,-0.3425E+00,-0.3485E+00,
     *-0.3538E+00,-0.3584E+00,-0.3620E+00,-0.3646E+00,-0.3662E+00,
     *-0.3667E+00,-0.3659E+00,-0.3638E+00,-0.3603E+00,-0.3553E+00,
     *-0.3487E+00,-0.3406E+00,-0.3307E+00,-0.3191E+00,-0.3058E+00,
     *-0.2907E+00,-0.2740E+00,-0.2557E+00,-0.2358E+00,-0.2147E+00,
     *-0.1925E+00,-0.1696E+00,-0.1463E+00,-0.1230E+00,-0.1004E+00,
     *-0.7876E-01,-0.5881E-01,-0.4108E-01,-0.2607E-01,-0.1421E-01,
     *-0.5822E-02,-0.1108E-02,-0.2604E-20 /
        DATA ((QHR(i,j),j=1,83),i=17,17)/
     *-0.3673E-22,-0.1188E-04,-0.8432E-04,-0.2988E-03,-0.7816E-03,
     *-0.1678E-02,-0.3123E-02,-0.5222E-02,-0.8035E-02,-0.1158E-01,
     *-0.1586E-01,-0.2082E-01,-0.2642E-01,-0.3263E-01,-0.3938E-01,
     *-0.4662E-01,-0.5433E-01,-0.6245E-01,-0.7095E-01,-0.7981E-01,
     *-0.8898E-01,-0.9844E-01,-0.1082E+00,-0.1181E+00,-0.1283E+00,
     *-0.1387E+00,-0.1492E+00,-0.1599E+00,-0.1707E+00,-0.1816E+00,
     *-0.1926E+00,-0.2036E+00,-0.2146E+00,-0.2257E+00,-0.2366E+00,
     *-0.2475E+00,-0.2583E+00,-0.2690E+00,-0.2795E+00,-0.2897E+00,
     *-0.2997E+00,-0.3046E+00,-0.3093E+00,-0.3186E+00,-0.3275E+00,
     *-0.3359E+00,-0.3438E+00,-0.3511E+00,-0.3577E+00,-0.3636E+00,
     *-0.3687E+00,-0.3729E+00,-0.3762E+00,-0.3784E+00,-0.3795E+00,
     *-0.3794E+00,-0.3780E+00,-0.3753E+00,-0.3711E+00,-0.3653E+00,
     *-0.3580E+00,-0.3490E+00,-0.3383E+00,-0.3259E+00,-0.3118E+00,
     *-0.2959E+00,-0.2784E+00,-0.2593E+00,-0.2387E+00,-0.2170E+00,
     *-0.1943E+00,-0.1709E+00,-0.1472E+00,-0.1236E+00,-0.1007E+00,
     *-0.7898E-01,-0.5895E-01,-0.4116E-01,-0.2611E-01,-0.1423E-01,
     *-0.5834E-02,-0.1111E-02, 0.1081E-20 /
        DATA ((QHR(i,j),j=1,83),i=18,18)/
     * 0.7005E-21,-0.1645E-03,-0.8690E-03,-0.2146E-02,-0.4009E-02,
     *-0.6477E-02,-0.9571E-02,-0.1331E-01,-0.1769E-01,-0.2274E-01,
     *-0.2843E-01,-0.3477E-01,-0.4172E-01,-0.4928E-01,-0.5740E-01,
     *-0.6607E-01,-0.7525E-01,-0.8491E-01,-0.9503E-01,-0.1056E+00,
     *-0.1165E+00,-0.1278E+00,-0.1394E+00,-0.1514E+00,-0.1636E+00,
     *-0.1760E+00,-0.1887E+00,-0.2015E+00,-0.2145E+00,-0.2275E+00,
     *-0.2407E+00,-0.2539E+00,-0.2670E+00,-0.2802E+00,-0.2932E+00,
     *-0.3061E+00,-0.3188E+00,-0.3313E+00,-0.3436E+00,-0.3555E+00,
     *-0.3670E+00,-0.3726E+00,-0.3780E+00,-0.3886E+00,-0.3986E+00,
     *-0.4079E+00,-0.4165E+00,-0.4244E+00,-0.4314E+00,-0.4375E+00,
     *-0.4425E+00,-0.4465E+00,-0.4493E+00,-0.4508E+00,-0.4510E+00,
     *-0.4497E+00,-0.4469E+00,-0.4426E+00,-0.4365E+00,-0.4288E+00,
     *-0.4192E+00,-0.4078E+00,-0.3945E+00,-0.3794E+00,-0.3624E+00,
     *-0.3435E+00,-0.3229E+00,-0.3006E+00,-0.2769E+00,-0.2518E+00,
     *-0.2258E+00,-0.1990E+00,-0.1719E+00,-0.1450E+00,-0.1187E+00,
     *-0.9361E-01,-0.7033E-01,-0.4948E-01,-0.3164E-01,-0.1738E-01,
     *-0.7169E-02,-0.1371E-02,-0.5448E-20 /
        DATA ((QHR(i,j),j=1,83),i=19,19)/
     *-0.7083E-21,-0.1681E-03,-0.8896E-03,-0.2204E-02,-0.4136E-02,
     *-0.6718E-02,-0.9979E-02,-0.1395E-01,-0.1864E-01,-0.2405E-01,
     *-0.3019E-01,-0.3704E-01,-0.4457E-01,-0.5275E-01,-0.6156E-01,
     *-0.7097E-01,-0.8093E-01,-0.9141E-01,-0.1024E+00,-0.1138E+00,
     *-0.1256E+00,-0.1378E+00,-0.1504E+00,-0.1632E+00,-0.1764E+00,
     *-0.1897E+00,-0.2033E+00,-0.2170E+00,-0.2308E+00,-0.2447E+00,
     *-0.2586E+00,-0.2725E+00,-0.2864E+00,-0.3001E+00,-0.3137E+00,
     *-0.3271E+00,-0.3402E+00,-0.3530E+00,-0.3655E+00,-0.3775E+00,
     *-0.3890E+00,-0.3946E+00,-0.4000E+00,-0.4103E+00,-0.4200E+00,
     *-0.4289E+00,-0.4370E+00,-0.4442E+00,-0.4504E+00,-0.4556E+00,
     *-0.4596E+00,-0.4624E+00,-0.4640E+00,-0.4641E+00,-0.4629E+00,
     *-0.4601E+00,-0.4557E+00,-0.4497E+00,-0.4420E+00,-0.4325E+00,
     *-0.4212E+00,-0.4081E+00,-0.3932E+00,-0.3765E+00,-0.3581E+00,
     *-0.3379E+00,-0.3162E+00,-0.2930E+00,-0.2685E+00,-0.2430E+00,
     *-0.2168E+00,-0.1901E+00,-0.1634E+00,-0.1371E+00,-0.1116E+00,
     *-0.8761E-01,-0.6551E-01,-0.4587E-01,-0.2921E-01,-0.1599E-01,
     *-0.6579E-02,-0.1257E-02, 0.8424E-20 /
        DATA ((QHR(i,j),j=1,83),i=20,20)/
     *-0.7188E-21,-0.2182E-03,-0.1157E-02,-0.2874E-02,-0.5413E-02,
     *-0.8822E-02,-0.1315E-01,-0.1842E-01,-0.2467E-01,-0.3188E-01,
     *-0.4007E-01,-0.4919E-01,-0.5922E-01,-0.7012E-01,-0.8184E-01,
     *-0.9433E-01,-0.1075E+00,-0.1214E+00,-0.1359E+00,-0.1509E+00,
     *-0.1664E+00,-0.1823E+00,-0.1986E+00,-0.2152E+00,-0.2320E+00,
     *-0.2491E+00,-0.2662E+00,-0.2833E+00,-0.3005E+00,-0.3175E+00,
     *-0.3344E+00,-0.3510E+00,-0.3674E+00,-0.3833E+00,-0.3988E+00,
     *-0.4138E+00,-0.4282E+00,-0.4419E+00,-0.4548E+00,-0.4669E+00,
     *-0.4782E+00,-0.4834E+00,-0.4884E+00,-0.4975E+00,-0.5056E+00,
     *-0.5124E+00,-0.5180E+00,-0.5222E+00,-0.5250E+00,-0.5263E+00,
     *-0.5261E+00,-0.5244E+00,-0.5210E+00,-0.5159E+00,-0.5091E+00,
     *-0.5006E+00,-0.4904E+00,-0.4784E+00,-0.4647E+00,-0.4493E+00,
     *-0.4322E+00,-0.4135E+00,-0.3933E+00,-0.3717E+00,-0.3487E+00,
     *-0.3247E+00,-0.2996E+00,-0.2738E+00,-0.2475E+00,-0.2209E+00,
     *-0.1944E+00,-0.1682E+00,-0.1427E+00,-0.1182E+00,-0.9509E-01,
     *-0.7378E-01,-0.5460E-01,-0.3789E-01,-0.2395E-01,-0.1303E-01,
     *-0.5337E-02,-0.1017E-02, 0.9963E-20 /
c************** MIE (phase fun uh) ***************
        DATA ((UHR(i,j),j=1,83),i= 1, 1)/
     *-0.4078E+00,-0.4006E+00,-0.3720E+00,-0.3280E+00,-0.2777E+00,
     *-0.2287E+00,-0.1851E+00,-0.1482E+00,-0.1175E+00,-0.9206E-01,
     *-0.7104E-01,-0.5377E-01,-0.3958E-01,-0.2786E-01,-0.1818E-01,
     *-0.1018E-01,-0.3538E-02, 0.2058E-02, 0.6933E-02, 0.1138E-01,
     * 0.1558E-01, 0.1965E-01, 0.2367E-01, 0.2775E-01, 0.3192E-01,
     * 0.3625E-01, 0.4080E-01, 0.4562E-01, 0.5078E-01, 0.5640E-01,
     * 0.6252E-01, 0.6919E-01, 0.7647E-01, 0.8447E-01, 0.9330E-01,
     * 0.1031E+00, 0.1138E+00, 0.1257E+00, 0.1389E+00, 0.1535E+00,
     * 0.1698E+00, 0.1786E+00, 0.1879E+00, 0.2080E+00, 0.2304E+00,
     * 0.2554E+00, 0.2834E+00, 0.3148E+00, 0.3499E+00, 0.3893E+00,
     * 0.4334E+00, 0.4829E+00, 0.5384E+00, 0.6011E+00, 0.6719E+00,
     * 0.7518E+00, 0.8419E+00, 0.9438E+00, 0.1059E+01, 0.1189E+01,
     * 0.1337E+01, 0.1504E+01, 0.1694E+01, 0.1909E+01, 0.2154E+01,
     * 0.2432E+01, 0.2747E+01, 0.3104E+01, 0.3510E+01, 0.3969E+01,
     * 0.4491E+01, 0.5083E+01, 0.5755E+01, 0.6516E+01, 0.7380E+01,
     * 0.8358E+01, 0.9463E+01, 0.1071E+02, 0.1208E+02, 0.1357E+02,
     * 0.1508E+02, 0.1632E+02, 0.1673E+02 /
        DATA ((UHR(i,j),j=1,83),i= 2, 2)/
     *-0.3768E+00,-0.3711E+00,-0.3481E+00,-0.3122E+00,-0.2704E+00,
     *-0.2286E+00,-0.1905E+00,-0.1574E+00,-0.1292E+00,-0.1051E+00,
     *-0.8476E-01,-0.6764E-01,-0.5336E-01,-0.4147E-01,-0.3151E-01,
     *-0.2308E-01,-0.1583E-01,-0.9485E-02,-0.3835E-02, 0.1322E-02,
     * 0.6165E-02, 0.1083E-01, 0.1543E-01, 0.2004E-01, 0.2475E-01,
     * 0.2959E-01, 0.3462E-01, 0.3992E-01, 0.4557E-01, 0.5169E-01,
     * 0.5837E-01, 0.6566E-01, 0.7359E-01, 0.8221E-01, 0.9162E-01,
     * 0.1019E+00, 0.1133E+00, 0.1260E+00, 0.1400E+00, 0.1555E+00,
     * 0.1726E+00, 0.1818E+00, 0.1915E+00, 0.2127E+00, 0.2362E+00,
     * 0.2624E+00, 0.2916E+00, 0.3243E+00, 0.3609E+00, 0.4018E+00,
     * 0.4476E+00, 0.4991E+00, 0.5568E+00, 0.6216E+00, 0.6946E+00,
     * 0.7768E+00, 0.8695E+00, 0.9741E+00, 0.1092E+01, 0.1226E+01,
     * 0.1376E+01, 0.1546E+01, 0.1739E+01, 0.1956E+01, 0.2202E+01,
     * 0.2481E+01, 0.2795E+01, 0.3150E+01, 0.3550E+01, 0.4001E+01,
     * 0.4509E+01, 0.5080E+01, 0.5721E+01, 0.6440E+01, 0.7243E+01,
     * 0.8139E+01, 0.9131E+01, 0.1022E+02, 0.1139E+02, 0.1261E+02,
     * 0.1379E+02, 0.1472E+02, 0.1501E+02 /
        DATA ((UHR(i,j),j=1,83),i= 3, 3)/
     *-0.3723E+00,-0.3668E+00,-0.3445E+00,-0.3097E+00,-0.2691E+00,
     *-0.2287E+00,-0.1917E+00,-0.1596E+00,-0.1320E+00,-0.1083E+00,
     *-0.8809E-01,-0.7094E-01,-0.5657E-01,-0.4462E-01,-0.3464E-01,
     *-0.2617E-01,-0.1883E-01,-0.1230E-01,-0.6407E-02,-0.1026E-02,
     * 0.3980E-02, 0.8757E-02, 0.1343E-01, 0.1811E-01, 0.2289E-01,
     * 0.2782E-01, 0.3298E-01, 0.3844E-01, 0.4427E-01, 0.5053E-01,
     * 0.5729E-01, 0.6466E-01, 0.7271E-01, 0.8148E-01, 0.9107E-01,
     * 0.1016E+00, 0.1131E+00, 0.1259E+00, 0.1401E+00, 0.1558E+00,
     * 0.1731E+00, 0.1825E+00, 0.1923E+00, 0.2137E+00, 0.2376E+00,
     * 0.2640E+00, 0.2936E+00, 0.3266E+00, 0.3634E+00, 0.4047E+00,
     * 0.4509E+00, 0.5028E+00, 0.5611E+00, 0.6265E+00, 0.7000E+00,
     * 0.7827E+00, 0.8758E+00, 0.9809E+00, 0.1099E+01, 0.1233E+01,
     * 0.1385E+01, 0.1555E+01, 0.1748E+01, 0.1966E+01, 0.2212E+01,
     * 0.2490E+01, 0.2804E+01, 0.3158E+01, 0.3556E+01, 0.4005E+01,
     * 0.4510E+01, 0.5076E+01, 0.5709E+01, 0.6418E+01, 0.7208E+01,
     * 0.8086E+01, 0.9054E+01, 0.1011E+02, 0.1125E+02, 0.1242E+02,
     * 0.1355E+02, 0.1442E+02, 0.1469E+02 /
        DATA ((UHR(i,j),j=1,83),i= 4, 4)/
     *-0.3587E+00,-0.3538E+00,-0.3340E+00,-0.3029E+00,-0.2662E+00,
     *-0.2290E+00,-0.1946E+00,-0.1643E+00,-0.1379E+00,-0.1151E+00,
     *-0.9555E-01,-0.7883E-01,-0.6466E-01,-0.5267E-01,-0.4247E-01,
     *-0.3369E-01,-0.2603E-01,-0.1922E-01,-0.1308E-01,-0.7422E-02,
     *-0.2095E-02, 0.3038E-02, 0.8084E-02, 0.1314E-01, 0.1827E-01,
     * 0.2355E-01, 0.2903E-01, 0.3478E-01, 0.4088E-01, 0.4745E-01,
     * 0.5458E-01, 0.6232E-01, 0.7072E-01, 0.7985E-01, 0.8979E-01,
     * 0.1007E+00, 0.1126E+00, 0.1259E+00, 0.1406E+00, 0.1567E+00,
     * 0.1746E+00, 0.1842E+00, 0.1944E+00, 0.2163E+00, 0.2408E+00,
     * 0.2680E+00, 0.2983E+00, 0.3321E+00, 0.3699E+00, 0.4120E+00,
     * 0.4593E+00, 0.5122E+00, 0.5716E+00, 0.6381E+00, 0.7128E+00,
     * 0.7969E+00, 0.8914E+00, 0.9979E+00, 0.1118E+01, 0.1253E+01,
     * 0.1406E+01, 0.1577E+01, 0.1771E+01, 0.1990E+01, 0.2236E+01,
     * 0.2514E+01, 0.2826E+01, 0.3177E+01, 0.3572E+01, 0.4014E+01,
     * 0.4509E+01, 0.5063E+01, 0.5679E+01, 0.6364E+01, 0.7122E+01,
     * 0.7956E+01, 0.8868E+01, 0.9851E+01, 0.1089E+02, 0.1194E+02,
     * 0.1293E+02, 0.1368E+02, 0.1390E+02 /
        DATA ((UHR(i,j),j=1,83),i= 5, 5)/
     *-0.3523E+00,-0.3476E+00,-0.3287E+00,-0.2992E+00,-0.2646E+00,
     *-0.2297E+00,-0.1972E+00,-0.1684E+00,-0.1431E+00,-0.1211E+00,
     *-0.1021E+00,-0.8570E-01,-0.7161E-01,-0.5955E-01,-0.4921E-01,
     *-0.4025E-01,-0.3236E-01,-0.2527E-01,-0.1880E-01,-0.1281E-01,
     *-0.7180E-02,-0.1787E-02, 0.3489E-02, 0.8745E-02, 0.1408E-01,
     * 0.1958E-01, 0.2534E-01, 0.3142E-01, 0.3787E-01, 0.4476E-01,
     * 0.5212E-01, 0.6006E-01, 0.6869E-01, 0.7810E-01, 0.8840E-01,
     * 0.9971E-01, 0.1121E+00, 0.1257E+00, 0.1407E+00, 0.1573E+00,
     * 0.1756E+00, 0.1855E+00, 0.1960E+00, 0.2185E+00, 0.2436E+00,
     * 0.2714E+00, 0.3024E+00, 0.3369E+00, 0.3753E+00, 0.4183E+00,
     * 0.4663E+00, 0.5201E+00, 0.5805E+00, 0.6481E+00, 0.7238E+00,
     * 0.8089E+00, 0.9044E+00, 0.1012E+01, 0.1133E+01, 0.1269E+01,
     * 0.1422E+01, 0.1595E+01, 0.1789E+01, 0.2008E+01, 0.2254E+01,
     * 0.2530E+01, 0.2841E+01, 0.3190E+01, 0.3580E+01, 0.4017E+01,
     * 0.4504E+01, 0.5046E+01, 0.5647E+01, 0.6312E+01, 0.7043E+01,
     * 0.7843E+01, 0.8710E+01, 0.9637E+01, 0.1061E+02, 0.1158E+02,
     * 0.1249E+02, 0.1316E+02, 0.1335E+02 /
        DATA ((UHR(i,j),j=1,83),i= 6, 6)/
     *-0.3444E+00,-0.3401E+00,-0.3229E+00,-0.2957E+00,-0.2633E+00,
     *-0.2300E+00,-0.1987E+00,-0.1707E+00,-0.1461E+00,-0.1246E+00,
     *-0.1060E+00,-0.8992E-01,-0.7601E-01,-0.6397E-01,-0.5350E-01,
     *-0.4437E-01,-0.3632E-01,-0.2916E-01,-0.2265E-01,-0.1660E-01,
     *-0.1085E-01,-0.5263E-02, 0.2490E-03, 0.5774E-02, 0.1138E-01,
     * 0.1711E-01, 0.2304E-01, 0.2924E-01, 0.3581E-01, 0.4285E-01,
     * 0.5044E-01, 0.5865E-01, 0.6753E-01, 0.7715E-01, 0.8765E-01,
     * 0.9912E-01, 0.1117E+00, 0.1256E+00, 0.1409E+00, 0.1578E+00,
     * 0.1765E+00, 0.1865E+00, 0.1971E+00, 0.2199E+00, 0.2453E+00,
     * 0.2735E+00, 0.3048E+00, 0.3398E+00, 0.3788E+00, 0.4223E+00,
     * 0.4709E+00, 0.5252E+00, 0.5860E+00, 0.6541E+00, 0.7305E+00,
     * 0.8163E+00, 0.9126E+00, 0.1021E+01, 0.1142E+01, 0.1279E+01,
     * 0.1433E+01, 0.1606E+01, 0.1800E+01, 0.2019E+01, 0.2265E+01,
     * 0.2541E+01, 0.2851E+01, 0.3198E+01, 0.3586E+01, 0.4018E+01,
     * 0.4500E+01, 0.5035E+01, 0.5627E+01, 0.6280E+01, 0.6995E+01,
     * 0.7774E+01, 0.8614E+01, 0.9505E+01, 0.1043E+02, 0.1135E+02,
     * 0.1219E+02, 0.1280E+02, 0.1298E+02 /
        DATA ((UHR(i,j),j=1,83),i= 7, 7)/
     *-0.3349E+00,-0.3310E+00,-0.3155E+00,-0.2907E+00,-0.2610E+00,
     *-0.2302E+00,-0.2010E+00,-0.1745E+00,-0.1510E+00,-0.1303E+00,
     *-0.1121E+00,-0.9630E-01,-0.8253E-01,-0.7056E-01,-0.6010E-01,
     *-0.5089E-01,-0.4269E-01,-0.3530E-01,-0.2853E-01,-0.2222E-01,
     *-0.1621E-01,-0.1038E-01,-0.4628E-02, 0.1127E-02, 0.6964E-02,
     * 0.1294E-01, 0.1912E-01, 0.2559E-01, 0.3242E-01, 0.3973E-01,
     * 0.4760E-01, 0.5611E-01, 0.6530E-01, 0.7525E-01, 0.8607E-01,
     * 0.9789E-01, 0.1108E+00, 0.1251E+00, 0.1408E+00, 0.1582E+00,
     * 0.1773E+00, 0.1875E+00, 0.1983E+00, 0.2217E+00, 0.2476E+00,
     * 0.2764E+00, 0.3084E+00, 0.3440E+00, 0.3837E+00, 0.4279E+00,
     * 0.4773E+00, 0.5325E+00, 0.5941E+00, 0.6631E+00, 0.7404E+00,
     * 0.8271E+00, 0.9243E+00, 0.1033E+01, 0.1156E+01, 0.1293E+01,
     * 0.1448E+01, 0.1621E+01, 0.1816E+01, 0.2035E+01, 0.2280E+01,
     * 0.2555E+01, 0.2863E+01, 0.3207E+01, 0.3591E+01, 0.4018E+01,
     * 0.4492E+01, 0.5017E+01, 0.5595E+01, 0.6230E+01, 0.6923E+01,
     * 0.7672E+01, 0.8475E+01, 0.9320E+01, 0.1019E+02, 0.1104E+02,
     * 0.1181E+02, 0.1236E+02, 0.1251E+02 /
        DATA ((UHR(i,j),j=1,83),i= 8, 8)/
     *-0.3249E+00,-0.3214E+00,-0.3072E+00,-0.2847E+00,-0.2577E+00,
     *-0.2297E+00,-0.2029E+00,-0.1784E+00,-0.1564E+00,-0.1368E+00,
     *-0.1195E+00,-0.1043E+00,-0.9085E-01,-0.7899E-01,-0.6850E-01,
     *-0.5916E-01,-0.5080E-01,-0.4321E-01,-0.3620E-01,-0.2960E-01,
     *-0.2328E-01,-0.1714E-01,-0.1110E-01,-0.5068E-02, 0.1041E-02,
     * 0.7320E-02, 0.1385E-01, 0.2071E-01, 0.2794E-01, 0.3562E-01,
     * 0.4381E-01, 0.5260E-01, 0.6211E-01, 0.7245E-01, 0.8374E-01,
     * 0.9606E-01, 0.1095E+00, 0.1243E+00, 0.1405E+00, 0.1583E+00,
     * 0.1780E+00, 0.1886E+00, 0.1998E+00, 0.2238E+00, 0.2505E+00,
     * 0.2800E+00, 0.3128E+00, 0.3493E+00, 0.3898E+00, 0.4350E+00,
     * 0.4853E+00, 0.5414E+00, 0.6041E+00, 0.6743E+00, 0.7527E+00,
     * 0.8405E+00, 0.9388E+00, 0.1049E+01, 0.1172E+01, 0.1311E+01,
     * 0.1466E+01, 0.1640E+01, 0.1835E+01, 0.2053E+01, 0.2297E+01,
     * 0.2571E+01, 0.2876E+01, 0.3216E+01, 0.3595E+01, 0.4015E+01,
     * 0.4479E+01, 0.4991E+01, 0.5553E+01, 0.6166E+01, 0.6831E+01,
     * 0.7546E+01, 0.8305E+01, 0.9098E+01, 0.9904E+01, 0.1069E+02,
     * 0.1138E+02, 0.1187E+02, 0.1200E+02 /
        DATA ((UHR(i,j),j=1,83),i= 9, 9)/
     *-0.3184E+00,-0.3152E+00,-0.3025E+00,-0.2823E+00,-0.2578E+00,
     *-0.2322E+00,-0.2074E+00,-0.1845E+00,-0.1637E+00,-0.1450E+00,
     *-0.1282E+00,-0.1133E+00,-0.9996E-01,-0.8816E-01,-0.7766E-01,
     *-0.6825E-01,-0.5970E-01,-0.5182E-01,-0.4446E-01,-0.3752E-01,
     *-0.3089E-01,-0.2446E-01,-0.1811E-01,-0.1176E-01,-0.5318E-02,
     * 0.1301E-02, 0.8176E-02, 0.1538E-01, 0.2299E-01, 0.3106E-01,
     * 0.3966E-01, 0.4889E-01, 0.5886E-01, 0.6966E-01, 0.8141E-01,
     * 0.9421E-01, 0.1082E+00, 0.1235E+00, 0.1403E+00, 0.1588E+00,
     * 0.1791E+00, 0.1901E+00, 0.2016E+00, 0.2264E+00, 0.2538E+00,
     * 0.2842E+00, 0.3178E+00, 0.3551E+00, 0.3966E+00, 0.4427E+00,
     * 0.4941E+00, 0.5514E+00, 0.6152E+00, 0.6865E+00, 0.7660E+00,
     * 0.8549E+00, 0.9542E+00, 0.1065E+01, 0.1190E+01, 0.1329E+01,
     * 0.1484E+01, 0.1659E+01, 0.1853E+01, 0.2071E+01, 0.2314E+01,
     * 0.2585E+01, 0.2887E+01, 0.3222E+01, 0.3594E+01, 0.4005E+01,
     * 0.4458E+01, 0.4956E+01, 0.5498E+01, 0.6088E+01, 0.6723E+01,
     * 0.7401E+01, 0.8115E+01, 0.8854E+01, 0.9596E+01, 0.1031E+02,
     * 0.1093E+02, 0.1135E+02, 0.1147E+02 /
        DATA ((UHR(i,j),j=1,83),i=10,10)/
     *-0.3086E+00,-0.3060E+00,-0.2951E+00,-0.2776E+00,-0.2562E+00,
     *-0.2333E+00,-0.2109E+00,-0.1898E+00,-0.1705E+00,-0.1528E+00,
     *-0.1368E+00,-0.1224E+00,-0.1094E+00,-0.9782E-01,-0.8738E-01,
     *-0.7791E-01,-0.6922E-01,-0.6116E-01,-0.5360E-01,-0.4641E-01,
     *-0.3949E-01,-0.3274E-01,-0.2605E-01,-0.1934E-01,-0.1252E-01,
     *-0.5525E-02, 0.1721E-02, 0.9294E-02, 0.1727E-01, 0.2574E-01,
     * 0.3478E-01, 0.4449E-01, 0.5495E-01, 0.6625E-01, 0.7849E-01,
     * 0.9181E-01, 0.1063E+00, 0.1222E+00, 0.1397E+00, 0.1588E+00,
     * 0.1799E+00, 0.1912E+00, 0.2030E+00, 0.2286E+00, 0.2568E+00,
     * 0.2880E+00, 0.3225E+00, 0.3608E+00, 0.4033E+00, 0.4505E+00,
     * 0.5029E+00, 0.5612E+00, 0.6262E+00, 0.6985E+00, 0.7792E+00,
     * 0.8691E+00, 0.9695E+00, 0.1082E+01, 0.1207E+01, 0.1347E+01,
     * 0.1503E+01, 0.1677E+01, 0.1871E+01, 0.2088E+01, 0.2329E+01,
     * 0.2598E+01, 0.2896E+01, 0.3226E+01, 0.3591E+01, 0.3994E+01,
     * 0.4435E+01, 0.4918E+01, 0.5443E+01, 0.6009E+01, 0.6616E+01,
     * 0.7260E+01, 0.7932E+01, 0.8620E+01, 0.9303E+01, 0.9947E+01,
     * 0.1050E+02, 0.1087E+02, 0.1097E+02 /
        DATA ((UHR(i,j),j=1,83),i=11,11)/
     *-0.3051E+00,-0.3027E+00,-0.2927E+00,-0.2765E+00,-0.2567E+00,
     *-0.2355E+00,-0.2146E+00,-0.1948E+00,-0.1764E+00,-0.1595E+00,
     *-0.1441E+00,-0.1301E+00,-0.1174E+00,-0.1059E+00,-0.9549E-01,
     *-0.8596E-01,-0.7715E-01,-0.6893E-01,-0.6116E-01,-0.5374E-01,
     *-0.4658E-01,-0.3957E-01,-0.3262E-01,-0.2564E-01,-0.1855E-01,
     *-0.1127E-01,-0.3707E-02, 0.4205E-02, 0.1254E-01, 0.2136E-01,
     * 0.3075E-01, 0.4081E-01, 0.5163E-01, 0.6332E-01, 0.7600E-01,
     * 0.8979E-01, 0.1048E+00, 0.1212E+00, 0.1392E+00, 0.1588E+00,
     * 0.1805E+00, 0.1921E+00, 0.2042E+00, 0.2305E+00, 0.2594E+00,
     * 0.2913E+00, 0.3266E+00, 0.3656E+00, 0.4089E+00, 0.4569E+00,
     * 0.5102E+00, 0.5694E+00, 0.6353E+00, 0.7085E+00, 0.7900E+00,
     * 0.8808E+00, 0.9819E+00, 0.1095E+01, 0.1220E+01, 0.1360E+01,
     * 0.1517E+01, 0.1691E+01, 0.1885E+01, 0.2100E+01, 0.2340E+01,
     * 0.2606E+01, 0.2901E+01, 0.3227E+01, 0.3586E+01, 0.3980E+01,
     * 0.4412E+01, 0.4883E+01, 0.5392E+01, 0.5940E+01, 0.6524E+01,
     * 0.7139E+01, 0.7779E+01, 0.8428E+01, 0.9068E+01, 0.9667E+01,
     * 0.1017E+02, 0.1051E+02, 0.1060E+02 /
        DATA ((UHR(i,j),j=1,83),i=12,12)/
     *-0.3033E+00,-0.3010E+00,-0.2917E+00,-0.2765E+00,-0.2578E+00,
     *-0.2375E+00,-0.2173E+00,-0.1981E+00,-0.1803E+00,-0.1638E+00,
     *-0.1488E+00,-0.1350E+00,-0.1225E+00,-0.1110E+00,-0.1006E+00,
     *-0.9095E-01,-0.8206E-01,-0.7377E-01,-0.6594E-01,-0.5843E-01,
     *-0.5113E-01,-0.4396E-01,-0.3681E-01,-0.2962E-01,-0.2232E-01,
     *-0.1482E-01,-0.7059E-02, 0.1045E-02, 0.9572E-02, 0.1861E-01,
     * 0.2824E-01, 0.3854E-01, 0.4962E-01, 0.6158E-01, 0.7452E-01,
     * 0.8859E-01, 0.1039E+00, 0.1206E+00, 0.1389E+00, 0.1589E+00,
     * 0.1809E+00, 0.1927E+00, 0.2051E+00, 0.2317E+00, 0.2610E+00,
     * 0.2934E+00, 0.3291E+00, 0.3687E+00, 0.4125E+00, 0.4610E+00,
     * 0.5148E+00, 0.5746E+00, 0.6409E+00, 0.7146E+00, 0.7967E+00,
     * 0.8880E+00, 0.9896E+00, 0.1103E+01, 0.1229E+01, 0.1369E+01,
     * 0.1525E+01, 0.1699E+01, 0.1892E+01, 0.2107E+01, 0.2346E+01,
     * 0.2610E+01, 0.2903E+01, 0.3226E+01, 0.3581E+01, 0.3971E+01,
     * 0.4397E+01, 0.4859E+01, 0.5359E+01, 0.5895E+01, 0.6465E+01,
     * 0.7064E+01, 0.7683E+01, 0.8309E+01, 0.8922E+01, 0.9490E+01,
     * 0.9968E+01, 0.1028E+02, 0.1037E+02 /
        DATA ((UHR(i,j),j=1,83),i=13,13)/
     *-0.2928E+00,-0.2910E+00,-0.2834E+00,-0.2710E+00,-0.2556E+00,
     *-0.2387E+00,-0.2216E+00,-0.2050E+00,-0.1892E+00,-0.1744E+00,
     *-0.1606E+00,-0.1478E+00,-0.1359E+00,-0.1249E+00,-0.1148E+00,
     *-0.1053E+00,-0.9640E-01,-0.8796E-01,-0.7989E-01,-0.7208E-01,
     *-0.6446E-01,-0.5694E-01,-0.4942E-01,-0.4184E-01,-0.3412E-01,
     *-0.2616E-01,-0.1791E-01,-0.9273E-02,-0.1876E-03, 0.9424E-02,
     * 0.1964E-01, 0.3057E-01, 0.4229E-01, 0.5494E-01, 0.6861E-01,
     * 0.8344E-01, 0.9955E-01, 0.1171E+00, 0.1363E+00, 0.1572E+00,
     * 0.1802E+00, 0.1925E+00, 0.2053E+00, 0.2330E+00, 0.2635E+00,
     * 0.2970E+00, 0.3340E+00, 0.3748E+00, 0.4198E+00, 0.4697E+00,
     * 0.5248E+00, 0.5860E+00, 0.6537E+00, 0.7288E+00, 0.8122E+00,
     * 0.9047E+00, 0.1007E+01, 0.1121E+01, 0.1248E+01, 0.1389E+01,
     * 0.1545E+01, 0.1719E+01, 0.1911E+01, 0.2124E+01, 0.2360E+01,
     * 0.2621E+01, 0.2908E+01, 0.3224E+01, 0.3570E+01, 0.3949E+01,
     * 0.4360E+01, 0.4805E+01, 0.5283E+01, 0.5792E+01, 0.6330E+01,
     * 0.6891E+01, 0.7465E+01, 0.8041E+01, 0.8597E+01, 0.9106E+01,
     * 0.9527E+01, 0.9801E+01, 0.9873E+01 /
        DATA ((UHR(i,j),j=1,83),i=14,14)/
     *-0.2827E+00,-0.2814E+00,-0.2759E+00,-0.2668E+00,-0.2553E+00,
     *-0.2423E+00,-0.2289E+00,-0.2154E+00,-0.2023E+00,-0.1897E+00,
     *-0.1776E+00,-0.1661E+00,-0.1553E+00,-0.1450E+00,-0.1353E+00,
     *-0.1261E+00,-0.1173E+00,-0.1089E+00,-0.1006E+00,-0.9258E-01,
     *-0.8462E-01,-0.7669E-01,-0.6871E-01,-0.6060E-01,-0.5231E-01,
     *-0.4375E-01,-0.3485E-01,-0.2554E-01,-0.1574E-01,-0.5368E-02,
     * 0.5651E-02, 0.1741E-01, 0.3002E-01, 0.4359E-01, 0.5823E-01,
     * 0.7408E-01, 0.9126E-01, 0.1099E+00, 0.1303E+00, 0.1524E+00,
     * 0.1767E+00, 0.1896E+00, 0.2032E+00, 0.2323E+00, 0.2642E+00,
     * 0.2992E+00, 0.3378E+00, 0.3802E+00, 0.4269E+00, 0.4785E+00,
     * 0.5354E+00, 0.5982E+00, 0.6676E+00, 0.7444E+00, 0.8293E+00,
     * 0.9233E+00, 0.1027E+01, 0.1142E+01, 0.1270E+01, 0.1411E+01,
     * 0.1567E+01, 0.1740E+01, 0.1931E+01, 0.2142E+01, 0.2374E+01,
     * 0.2630E+01, 0.2910E+01, 0.3218E+01, 0.3553E+01, 0.3917E+01,
     * 0.4311E+01, 0.4735E+01, 0.5187E+01, 0.5665E+01, 0.6166E+01,
     * 0.6683E+01, 0.7207E+01, 0.7724E+01, 0.8217E+01, 0.8660E+01,
     * 0.9018E+01, 0.9246E+01, 0.9304E+01 /
        DATA ((UHR(i,j),j=1,83),i=15,15)/
     *-0.3014E+00,-0.3009E+00,-0.2985E+00,-0.2944E+00,-0.2890E+00,
     *-0.2825E+00,-0.2751E+00,-0.2673E+00,-0.2590E+00,-0.2505E+00,
     *-0.2419E+00,-0.2331E+00,-0.2243E+00,-0.2156E+00,-0.2068E+00,
     *-0.1980E+00,-0.1893E+00,-0.1805E+00,-0.1716E+00,-0.1626E+00,
     *-0.1535E+00,-0.1442E+00,-0.1346E+00,-0.1247E+00,-0.1144E+00,
     *-0.1037E+00,-0.9251E-01,-0.8074E-01,-0.6832E-01,-0.5518E-01,
     *-0.4121E-01,-0.2635E-01,-0.1047E-01, 0.6534E-02, 0.2477E-01,
     * 0.4438E-01, 0.6551E-01, 0.8830E-01, 0.1129E+00, 0.1396E+00,
     * 0.1685E+00, 0.1838E+00, 0.1998E+00, 0.2338E+00, 0.2708E+00,
     * 0.3111E+00, 0.3549E+00, 0.4027E+00, 0.4548E+00, 0.5117E+00,
     * 0.5738E+00, 0.6417E+00, 0.7158E+00, 0.7969E+00, 0.8856E+00,
     * 0.9826E+00, 0.1089E+01, 0.1205E+01, 0.1332E+01, 0.1470E+01,
     * 0.1622E+01, 0.1787E+01, 0.1967E+01, 0.2163E+01, 0.2376E+01,
     * 0.2607E+01, 0.2857E+01, 0.3126E+01, 0.3415E+01, 0.3724E+01,
     * 0.4052E+01, 0.4398E+01, 0.4760E+01, 0.5134E+01, 0.5516E+01,
     * 0.5900E+01, 0.6278E+01, 0.6639E+01, 0.6970E+01, 0.7254E+01,
     * 0.7473E+01, 0.7606E+01, 0.7638E+01 /
        DATA ((UHR(i,j),j=1,83),i=16,16)/
     *-0.3262E+00,-0.3259E+00,-0.3248E+00,-0.3228E+00,-0.3200E+00,
     *-0.3164E+00,-0.3121E+00,-0.3072E+00,-0.3018E+00,-0.2959E+00,
     *-0.2897E+00,-0.2832E+00,-0.2764E+00,-0.2693E+00,-0.2621E+00,
     *-0.2545E+00,-0.2468E+00,-0.2388E+00,-0.2306E+00,-0.2220E+00,
     *-0.2131E+00,-0.2039E+00,-0.1942E+00,-0.1841E+00,-0.1735E+00,
     *-0.1624E+00,-0.1506E+00,-0.1382E+00,-0.1250E+00,-0.1110E+00,
     *-0.9608E-01,-0.8017E-01,-0.6318E-01,-0.4499E-01,-0.2548E-01,
     *-0.4541E-02, 0.1797E-01, 0.4221E-01, 0.6834E-01, 0.9654E-01,
     * 0.1270E+00, 0.1431E+00, 0.1599E+00, 0.1956E+00, 0.2342E+00,
     * 0.2761E+00, 0.3216E+00, 0.3709E+00, 0.4245E+00, 0.4829E+00,
     * 0.5463E+00, 0.6154E+00, 0.6907E+00, 0.7726E+00, 0.8620E+00,
     * 0.9595E+00, 0.1066E+01, 0.1182E+01, 0.1308E+01, 0.1446E+01,
     * 0.1596E+01, 0.1760E+01, 0.1938E+01, 0.2132E+01, 0.2343E+01,
     * 0.2571E+01, 0.2818E+01, 0.3084E+01, 0.3370E+01, 0.3675E+01,
     * 0.4000E+01, 0.4343E+01, 0.4702E+01, 0.5074E+01, 0.5453E+01,
     * 0.5834E+01, 0.6207E+01, 0.6562E+01, 0.6884E+01, 0.7159E+01,
     * 0.7368E+01, 0.7493E+01, 0.7523E+01 /
        DATA ((UHR(i,j),j=1,83),i=17,17)/
     *-0.3448E+00,-0.3446E+00,-0.3435E+00,-0.3415E+00,-0.3386E+00,
     *-0.3350E+00,-0.3307E+00,-0.3258E+00,-0.3203E+00,-0.3144E+00,
     *-0.3081E+00,-0.3014E+00,-0.2945E+00,-0.2872E+00,-0.2797E+00,
     *-0.2720E+00,-0.2639E+00,-0.2556E+00,-0.2470E+00,-0.2381E+00,
     *-0.2288E+00,-0.2191E+00,-0.2089E+00,-0.1983E+00,-0.1871E+00,
     *-0.1754E+00,-0.1630E+00,-0.1499E+00,-0.1361E+00,-0.1213E+00,
     *-0.1057E+00,-0.8898E-01,-0.7117E-01,-0.5212E-01,-0.3173E-01,
     *-0.9874E-02, 0.1359E-01, 0.3881E-01, 0.6594E-01, 0.9517E-01,
     * 0.1267E+00, 0.1434E+00, 0.1607E+00, 0.1974E+00, 0.2371E+00,
     * 0.2801E+00, 0.3266E+00, 0.3770E+00, 0.4316E+00, 0.4909E+00,
     * 0.5552E+00, 0.6251E+00, 0.7009E+00, 0.7834E+00, 0.8731E+00,
     * 0.9705E+00, 0.1077E+01, 0.1192E+01, 0.1317E+01, 0.1454E+01,
     * 0.1602E+01, 0.1762E+01, 0.1937E+01, 0.2126E+01, 0.2331E+01,
     * 0.2552E+01, 0.2790E+01, 0.3046E+01, 0.3320E+01, 0.3612E+01,
     * 0.3921E+01, 0.4246E+01, 0.4584E+01, 0.4932E+01, 0.5287E+01,
     * 0.5640E+01, 0.5985E+01, 0.6311E+01, 0.6605E+01, 0.6855E+01,
     * 0.7043E+01, 0.7155E+01, 0.7182E+01 /
        DATA ((UHR(i,j),j=1,83),i=18,18)/
     *-0.3923E+00,-0.3921E+00,-0.3914E+00,-0.3903E+00,-0.3886E+00,
     *-0.3863E+00,-0.3835E+00,-0.3802E+00,-0.3764E+00,-0.3720E+00,
     *-0.3671E+00,-0.3618E+00,-0.3560E+00,-0.3497E+00,-0.3429E+00,
     *-0.3357E+00,-0.3280E+00,-0.3198E+00,-0.3112E+00,-0.3019E+00,
     *-0.2922E+00,-0.2818E+00,-0.2708E+00,-0.2592E+00,-0.2469E+00,
     *-0.2338E+00,-0.2198E+00,-0.2050E+00,-0.1893E+00,-0.1725E+00,
     *-0.1547E+00,-0.1357E+00,-0.1154E+00,-0.9369E-01,-0.7052E-01,
     *-0.4576E-01,-0.1925E-01, 0.9120E-02, 0.3952E-01, 0.7211E-01,
     * 0.1071E+00, 0.1255E+00, 0.1446E+00, 0.1849E+00, 0.2281E+00,
     * 0.2746E+00, 0.3246E+00, 0.3784E+00, 0.4363E+00, 0.4986E+00,
     * 0.5657E+00, 0.6379E+00, 0.7157E+00, 0.7995E+00, 0.8897E+00,
     * 0.9870E+00, 0.1092E+01, 0.1205E+01, 0.1326E+01, 0.1457E+01,
     * 0.1597E+01, 0.1748E+01, 0.1910E+01, 0.2083E+01, 0.2269E+01,
     * 0.2467E+01, 0.2678E+01, 0.2903E+01, 0.3140E+01, 0.3389E+01,
     * 0.3650E+01, 0.3921E+01, 0.4201E+01, 0.4485E+01, 0.4771E+01,
     * 0.5054E+01, 0.5326E+01, 0.5581E+01, 0.5809E+01, 0.6000E+01,
     * 0.6143E+01, 0.6227E+01, 0.6248E+01 /
        DATA ((UHR(i,j),j=1,83),i=19,19)/
     *-0.4345E+00,-0.4343E+00,-0.4335E+00,-0.4321E+00,-0.4301E+00,
     *-0.4275E+00,-0.4242E+00,-0.4203E+00,-0.4159E+00,-0.4109E+00,
     *-0.4053E+00,-0.3992E+00,-0.3926E+00,-0.3854E+00,-0.3778E+00,
     *-0.3696E+00,-0.3610E+00,-0.3518E+00,-0.3420E+00,-0.3317E+00,
     *-0.3208E+00,-0.3092E+00,-0.2970E+00,-0.2841E+00,-0.2704E+00,
     *-0.2559E+00,-0.2406E+00,-0.2243E+00,-0.2071E+00,-0.1888E+00,
     *-0.1693E+00,-0.1487E+00,-0.1267E+00,-0.1033E+00,-0.7835E-01,
     *-0.5180E-01,-0.2348E-01, 0.6725E-02, 0.3897E-01, 0.7340E-01,
     * 0.1102E+00, 0.1295E+00, 0.1495E+00, 0.1916E+00, 0.2366E+00,
     * 0.2848E+00, 0.3364E+00, 0.3916E+00, 0.4508E+00, 0.5142E+00,
     * 0.5822E+00, 0.6551E+00, 0.7333E+00, 0.8170E+00, 0.9069E+00,
     * 0.1003E+01, 0.1106E+01, 0.1217E+01, 0.1335E+01, 0.1462E+01,
     * 0.1598E+01, 0.1742E+01, 0.1897E+01, 0.2062E+01, 0.2237E+01,
     * 0.2423E+01, 0.2619E+01, 0.2826E+01, 0.3044E+01, 0.3272E+01,
     * 0.3508E+01, 0.3752E+01, 0.4001E+01, 0.4252E+01, 0.4503E+01,
     * 0.4748E+01, 0.4981E+01, 0.5198E+01, 0.5389E+01, 0.5548E+01,
     * 0.5666E+01, 0.5734E+01, 0.5750E+01 /
        DATA ((UHR(i,j),j=1,83),i=20,20)/
     *-0.6107E+00,-0.6105E+00,-0.6093E+00,-0.6072E+00,-0.6042E+00,
     *-0.6003E+00,-0.5955E+00,-0.5899E+00,-0.5835E+00,-0.5763E+00,
     *-0.5683E+00,-0.5596E+00,-0.5501E+00,-0.5399E+00,-0.5290E+00,
     *-0.5173E+00,-0.5049E+00,-0.4917E+00,-0.4778E+00,-0.4630E+00,
     *-0.4475E+00,-0.4311E+00,-0.4138E+00,-0.3956E+00,-0.3764E+00,
     *-0.3562E+00,-0.3350E+00,-0.3126E+00,-0.2891E+00,-0.2643E+00,
     *-0.2383E+00,-0.2109E+00,-0.1820E+00,-0.1516E+00,-0.1196E+00,
     *-0.8596E-01,-0.5050E-01,-0.1316E-01, 0.2617E-01, 0.6760E-01,
     * 0.1112E+00, 0.1339E+00, 0.1572E+00, 0.2057E+00, 0.2567E+00,
     * 0.3104E+00, 0.3671E+00, 0.4268E+00, 0.4896E+00, 0.5558E+00,
     * 0.6255E+00, 0.6989E+00, 0.7761E+00, 0.8573E+00, 0.9428E+00,
     * 0.1033E+01, 0.1127E+01, 0.1226E+01, 0.1330E+01, 0.1438E+01,
     * 0.1552E+01, 0.1670E+01, 0.1794E+01, 0.1923E+01, 0.2056E+01,
     * 0.2195E+01, 0.2337E+01, 0.2483E+01, 0.2633E+01, 0.2784E+01,
     * 0.2938E+01, 0.3091E+01, 0.3243E+01, 0.3392E+01, 0.3535E+01,
     * 0.3671E+01, 0.3796E+01, 0.3909E+01, 0.4005E+01, 0.4082E+01,
     * 0.4138E+01, 0.4170E+01, 0.4177E+01 /



      vi_m=0.00182737305
      vi(2)=vi_m
      do 1 i=1,20
       asy(2,i)=asy_m(i)
       ex(2,i)=ex_m(i)
       sc(2,i)=sc_m(i)
      do 1 j=1,nquad
      ph(i,j)=phr(i,j)
      qh(i,j)=qhr(i,j)
      uh(i,j)=uhr(i,j)
    1 continue
      return
      end

